# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiImpalaQuery(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'query_id': 'str',
        'statement': 'str',
        'query_type': 'str',
        'query_state': 'str',
        'start_time': 'str',
        'end_time': 'str',
        'rows_produced': 'int',
        'attributes': 'dict(str, str)',
        'user': 'str',
        'coordinator': 'ApiHostRef',
        'details_available': 'bool',
        'database': 'str',
        'duration_millis': 'int'
    }

    attribute_map = {
        'query_id': 'queryId',
        'statement': 'statement',
        'query_type': 'queryType',
        'query_state': 'queryState',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'rows_produced': 'rowsProduced',
        'attributes': 'attributes',
        'user': 'user',
        'coordinator': 'coordinator',
        'details_available': 'detailsAvailable',
        'database': 'database',
        'duration_millis': 'durationMillis'
    }

    def __init__(self, query_id=None, statement=None, query_type=None, query_state=None, start_time=None, end_time=None, rows_produced=None, attributes=None, user=None, coordinator=None, details_available=None, database=None, duration_millis=None):
        """
        ApiImpalaQuery - a model defined in Swagger
        """

        self._query_id = None
        self._statement = None
        self._query_type = None
        self._query_state = None
        self._start_time = None
        self._end_time = None
        self._rows_produced = None
        self._attributes = None
        self._user = None
        self._coordinator = None
        self._details_available = None
        self._database = None
        self._duration_millis = None

        if query_id is not None:
          self.query_id = query_id
        if statement is not None:
          self.statement = statement
        if query_type is not None:
          self.query_type = query_type
        if query_state is not None:
          self.query_state = query_state
        if start_time is not None:
          self.start_time = start_time
        if end_time is not None:
          self.end_time = end_time
        if rows_produced is not None:
          self.rows_produced = rows_produced
        if attributes is not None:
          self.attributes = attributes
        if user is not None:
          self.user = user
        if coordinator is not None:
          self.coordinator = coordinator
        if details_available is not None:
          self.details_available = details_available
        if database is not None:
          self.database = database
        if duration_millis is not None:
          self.duration_millis = duration_millis

    @property
    def query_id(self):
        """
        Gets the query_id of this ApiImpalaQuery.
        The query id.

        :return: The query_id of this ApiImpalaQuery.
        :rtype: str
        """
        return self._query_id

    @query_id.setter
    def query_id(self, query_id):
        """
        Sets the query_id of this ApiImpalaQuery.
        The query id.

        :param query_id: The query_id of this ApiImpalaQuery.
        :type: str
        """

        self._query_id = query_id

    @property
    def statement(self):
        """
        Gets the statement of this ApiImpalaQuery.
        The SQL statement for the query.

        :return: The statement of this ApiImpalaQuery.
        :rtype: str
        """
        return self._statement

    @statement.setter
    def statement(self, statement):
        """
        Sets the statement of this ApiImpalaQuery.
        The SQL statement for the query.

        :param statement: The statement of this ApiImpalaQuery.
        :type: str
        """

        self._statement = statement

    @property
    def query_type(self):
        """
        Gets the query_type of this ApiImpalaQuery.
        The query type. The possible values are: DML, DDL, QUERY and UNKNOWN. See the Impala documentation for more details.

        :return: The query_type of this ApiImpalaQuery.
        :rtype: str
        """
        return self._query_type

    @query_type.setter
    def query_type(self, query_type):
        """
        Sets the query_type of this ApiImpalaQuery.
        The query type. The possible values are: DML, DDL, QUERY and UNKNOWN. See the Impala documentation for more details.

        :param query_type: The query_type of this ApiImpalaQuery.
        :type: str
        """

        self._query_type = query_type

    @property
    def query_state(self):
        """
        Gets the query_state of this ApiImpalaQuery.
        The query state. The possible values are: CREATED, INITIALIZED, COMPILED, RUNNING, FINISHED, EXCEPTION, and UNKNOWN. See the Impala documentation for more details.

        :return: The query_state of this ApiImpalaQuery.
        :rtype: str
        """
        return self._query_state

    @query_state.setter
    def query_state(self, query_state):
        """
        Sets the query_state of this ApiImpalaQuery.
        The query state. The possible values are: CREATED, INITIALIZED, COMPILED, RUNNING, FINISHED, EXCEPTION, and UNKNOWN. See the Impala documentation for more details.

        :param query_state: The query_state of this ApiImpalaQuery.
        :type: str
        """

        self._query_state = query_state

    @property
    def start_time(self):
        """
        Gets the start_time of this ApiImpalaQuery.
        The time the query was issued.

        :return: The start_time of this ApiImpalaQuery.
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Sets the start_time of this ApiImpalaQuery.
        The time the query was issued.

        :param start_time: The start_time of this ApiImpalaQuery.
        :type: str
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """
        Gets the end_time of this ApiImpalaQuery.
        The time the query finished. If the query hasn't finished then this will return null.

        :return: The end_time of this ApiImpalaQuery.
        :rtype: str
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """
        Sets the end_time of this ApiImpalaQuery.
        The time the query finished. If the query hasn't finished then this will return null.

        :param end_time: The end_time of this ApiImpalaQuery.
        :type: str
        """

        self._end_time = end_time

    @property
    def rows_produced(self):
        """
        Gets the rows_produced of this ApiImpalaQuery.
        The number of rows produced by the query. If the query hasn't completed this will return null.

        :return: The rows_produced of this ApiImpalaQuery.
        :rtype: int
        """
        return self._rows_produced

    @rows_produced.setter
    def rows_produced(self, rows_produced):
        """
        Sets the rows_produced of this ApiImpalaQuery.
        The number of rows produced by the query. If the query hasn't completed this will return null.

        :param rows_produced: The rows_produced of this ApiImpalaQuery.
        :type: int
        """

        self._rows_produced = rows_produced

    @property
    def attributes(self):
        """
        Gets the attributes of this ApiImpalaQuery.
        A map of additional query attributes which is generated by Cloudera Manager.

        :return: The attributes of this ApiImpalaQuery.
        :rtype: dict(str, str)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Sets the attributes of this ApiImpalaQuery.
        A map of additional query attributes which is generated by Cloudera Manager.

        :param attributes: The attributes of this ApiImpalaQuery.
        :type: dict(str, str)
        """

        self._attributes = attributes

    @property
    def user(self):
        """
        Gets the user of this ApiImpalaQuery.
        The user who issued this query.

        :return: The user of this ApiImpalaQuery.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this ApiImpalaQuery.
        The user who issued this query.

        :param user: The user of this ApiImpalaQuery.
        :type: str
        """

        self._user = user

    @property
    def coordinator(self):
        """
        Gets the coordinator of this ApiImpalaQuery.
        The host of the Impala Daemon coordinating the query

        :return: The coordinator of this ApiImpalaQuery.
        :rtype: ApiHostRef
        """
        return self._coordinator

    @coordinator.setter
    def coordinator(self, coordinator):
        """
        Sets the coordinator of this ApiImpalaQuery.
        The host of the Impala Daemon coordinating the query

        :param coordinator: The coordinator of this ApiImpalaQuery.
        :type: ApiHostRef
        """

        self._coordinator = coordinator

    @property
    def details_available(self):
        """
        Gets the details_available of this ApiImpalaQuery.
        Whether we have a detailed runtime profile available for the query. This profile is available at the endpoint /queries/{QUERY_ID}.

        :return: The details_available of this ApiImpalaQuery.
        :rtype: bool
        """
        return self._details_available

    @details_available.setter
    def details_available(self, details_available):
        """
        Sets the details_available of this ApiImpalaQuery.
        Whether we have a detailed runtime profile available for the query. This profile is available at the endpoint /queries/{QUERY_ID}.

        :param details_available: The details_available of this ApiImpalaQuery.
        :type: bool
        """

        self._details_available = details_available

    @property
    def database(self):
        """
        Gets the database of this ApiImpalaQuery.
        The database on which this query was issued.

        :return: The database of this ApiImpalaQuery.
        :rtype: str
        """
        return self._database

    @database.setter
    def database(self, database):
        """
        Sets the database of this ApiImpalaQuery.
        The database on which this query was issued.

        :param database: The database of this ApiImpalaQuery.
        :type: str
        """

        self._database = database

    @property
    def duration_millis(self):
        """
        Gets the duration_millis of this ApiImpalaQuery.
        The duration of the query in milliseconds. If the query hasn't completed then this will return null.

        :return: The duration_millis of this ApiImpalaQuery.
        :rtype: int
        """
        return self._duration_millis

    @duration_millis.setter
    def duration_millis(self, duration_millis):
        """
        Sets the duration_millis of this ApiImpalaQuery.
        The duration of the query in milliseconds. If the query hasn't completed then this will return null.

        :param duration_millis: The duration_millis of this ApiImpalaQuery.
        :type: int
        """

        self._duration_millis = duration_millis

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiImpalaQuery):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
