# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiExternalAccount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'display_name': 'str',
        'created_time': 'str',
        'last_modified_time': 'str',
        'type_name': 'str',
        'account_configs': 'ApiConfigList'
    }

    attribute_map = {
        'name': 'name',
        'display_name': 'displayName',
        'created_time': 'createdTime',
        'last_modified_time': 'lastModifiedTime',
        'type_name': 'typeName',
        'account_configs': 'accountConfigs'
    }

    def __init__(self, name=None, display_name=None, created_time=None, last_modified_time=None, type_name=None, account_configs=None):
        """
        ApiExternalAccount - a model defined in Swagger
        """

        self._name = None
        self._display_name = None
        self._created_time = None
        self._last_modified_time = None
        self._type_name = None
        self._account_configs = None

        if name is not None:
          self.name = name
        if display_name is not None:
          self.display_name = display_name
        if created_time is not None:
          self.created_time = created_time
        if last_modified_time is not None:
          self.last_modified_time = last_modified_time
        if type_name is not None:
          self.type_name = type_name
        if account_configs is not None:
          self.account_configs = account_configs

    @property
    def name(self):
        """
        Gets the name of this ApiExternalAccount.
        Represents the intial name of the account; used to uniquely identify this account.

        :return: The name of this ApiExternalAccount.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiExternalAccount.
        Represents the intial name of the account; used to uniquely identify this account.

        :param name: The name of this ApiExternalAccount.
        :type: str
        """

        self._name = name

    @property
    def display_name(self):
        """
        Gets the display_name of this ApiExternalAccount.
        Represents a modifiable label to identify this account for user-visible purposes.

        :return: The display_name of this ApiExternalAccount.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiExternalAccount.
        Represents a modifiable label to identify this account for user-visible purposes.

        :param display_name: The display_name of this ApiExternalAccount.
        :type: str
        """

        self._display_name = display_name

    @property
    def created_time(self):
        """
        Gets the created_time of this ApiExternalAccount.
        Represents the time of creation for this account.

        :return: The created_time of this ApiExternalAccount.
        :rtype: str
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """
        Sets the created_time of this ApiExternalAccount.
        Represents the time of creation for this account.

        :param created_time: The created_time of this ApiExternalAccount.
        :type: str
        """

        self._created_time = created_time

    @property
    def last_modified_time(self):
        """
        Gets the last_modified_time of this ApiExternalAccount.
        Represents the last modification time for this account.

        :return: The last_modified_time of this ApiExternalAccount.
        :rtype: str
        """
        return self._last_modified_time

    @last_modified_time.setter
    def last_modified_time(self, last_modified_time):
        """
        Sets the last_modified_time of this ApiExternalAccount.
        Represents the last modification time for this account.

        :param last_modified_time: The last_modified_time of this ApiExternalAccount.
        :type: str
        """

        self._last_modified_time = last_modified_time

    @property
    def type_name(self):
        """
        Gets the type_name of this ApiExternalAccount.
        Represents the Type ID of a supported external account type. The type represented by this field dictates which configuration options must be defined for this account.

        :return: The type_name of this ApiExternalAccount.
        :rtype: str
        """
        return self._type_name

    @type_name.setter
    def type_name(self, type_name):
        """
        Sets the type_name of this ApiExternalAccount.
        Represents the Type ID of a supported external account type. The type represented by this field dictates which configuration options must be defined for this account.

        :param type_name: The type_name of this ApiExternalAccount.
        :type: str
        """

        self._type_name = type_name

    @property
    def account_configs(self):
        """
        Gets the account_configs of this ApiExternalAccount.
        Represents the account configuration for this account.  When an account is retrieved from the server, the configs returned must match allowed configuration for the type of this account.  When specified for creation of a new account or for the update of an existing account, this field must include every required configuration parameter specified in the type's definition, with the account configuration's value field specified to represent the specific configuration desired for this account.

        :return: The account_configs of this ApiExternalAccount.
        :rtype: ApiConfigList
        """
        return self._account_configs

    @account_configs.setter
    def account_configs(self, account_configs):
        """
        Sets the account_configs of this ApiExternalAccount.
        Represents the account configuration for this account.  When an account is retrieved from the server, the configs returned must match allowed configuration for the type of this account.  When specified for creation of a new account or for the update of an existing account, this field must include every required configuration parameter specified in the type's definition, with the account configuration's value field specified to represent the specific configuration desired for this account.

        :param account_configs: The account_configs of this ApiExternalAccount.
        :type: ApiConfigList
        """

        self._account_configs = account_configs

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiExternalAccount):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
