# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'value': 'str',
        'required': 'bool',
        'default': 'str',
        'display_name': 'str',
        'description': 'str',
        'related_name': 'str',
        'sensitive': 'bool',
        'validation_state': 'ValidationState',
        'validation_message': 'str',
        'validation_warnings_suppressed': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'value': 'value',
        'required': 'required',
        'default': 'default',
        'display_name': 'displayName',
        'description': 'description',
        'related_name': 'relatedName',
        'sensitive': 'sensitive',
        'validation_state': 'validationState',
        'validation_message': 'validationMessage',
        'validation_warnings_suppressed': 'validationWarningsSuppressed'
    }

    def __init__(self, name=None, value=None, required=None, default=None, display_name=None, description=None, related_name=None, sensitive=None, validation_state=None, validation_message=None, validation_warnings_suppressed=None):
        """
        ApiConfig - a model defined in Swagger
        """

        self._name = None
        self._value = None
        self._required = None
        self._default = None
        self._display_name = None
        self._description = None
        self._related_name = None
        self._sensitive = None
        self._validation_state = None
        self._validation_message = None
        self._validation_warnings_suppressed = None

        if name is not None:
          self.name = name
        if value is not None:
          self.value = value
        if required is not None:
          self.required = required
        if default is not None:
          self.default = default
        if display_name is not None:
          self.display_name = display_name
        if description is not None:
          self.description = description
        if related_name is not None:
          self.related_name = related_name
        if sensitive is not None:
          self.sensitive = sensitive
        if validation_state is not None:
          self.validation_state = validation_state
        if validation_message is not None:
          self.validation_message = validation_message
        if validation_warnings_suppressed is not None:
          self.validation_warnings_suppressed = validation_warnings_suppressed

    @property
    def name(self):
        """
        Gets the name of this ApiConfig.
        Readonly. The canonical name that identifies this configuration parameter.

        :return: The name of this ApiConfig.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiConfig.
        Readonly. The canonical name that identifies this configuration parameter.

        :param name: The name of this ApiConfig.
        :type: str
        """

        self._name = name

    @property
    def value(self):
        """
        Gets the value of this ApiConfig.
        The user-defined value. When absent, the default value (if any) will be used. Can also be absent, when enumerating allowed configs.

        :return: The value of this ApiConfig.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ApiConfig.
        The user-defined value. When absent, the default value (if any) will be used. Can also be absent, when enumerating allowed configs.

        :param value: The value of this ApiConfig.
        :type: str
        """

        self._value = value

    @property
    def required(self):
        """
        Gets the required of this ApiConfig.
        Readonly. Requires \"full\" view. Whether this configuration is required for the object. If any required configuration is not set, operations on the object may not work.

        :return: The required of this ApiConfig.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this ApiConfig.
        Readonly. Requires \"full\" view. Whether this configuration is required for the object. If any required configuration is not set, operations on the object may not work.

        :param required: The required of this ApiConfig.
        :type: bool
        """

        self._required = required

    @property
    def default(self):
        """
        Gets the default of this ApiConfig.
        Readonly. Requires \"full\" view. The default value.

        :return: The default of this ApiConfig.
        :rtype: str
        """
        return self._default

    @default.setter
    def default(self, default):
        """
        Sets the default of this ApiConfig.
        Readonly. Requires \"full\" view. The default value.

        :param default: The default of this ApiConfig.
        :type: str
        """

        self._default = default

    @property
    def display_name(self):
        """
        Gets the display_name of this ApiConfig.
        Readonly. Requires \"full\" view. A user-friendly name of the parameters, as would have been shown in the web UI.

        :return: The display_name of this ApiConfig.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiConfig.
        Readonly. Requires \"full\" view. A user-friendly name of the parameters, as would have been shown in the web UI.

        :param display_name: The display_name of this ApiConfig.
        :type: str
        """

        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this ApiConfig.
        Readonly. Requires \"full\" view. A textual description of the parameter.

        :return: The description of this ApiConfig.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ApiConfig.
        Readonly. Requires \"full\" view. A textual description of the parameter.

        :param description: The description of this ApiConfig.
        :type: str
        """

        self._description = description

    @property
    def related_name(self):
        """
        Gets the related_name of this ApiConfig.
        Readonly. Requires \"full\" view. If applicable, contains the related configuration variable used by the source project.

        :return: The related_name of this ApiConfig.
        :rtype: str
        """
        return self._related_name

    @related_name.setter
    def related_name(self, related_name):
        """
        Sets the related_name of this ApiConfig.
        Readonly. Requires \"full\" view. If applicable, contains the related configuration variable used by the source project.

        :param related_name: The related_name of this ApiConfig.
        :type: str
        """

        self._related_name = related_name

    @property
    def sensitive(self):
        """
        Gets the sensitive of this ApiConfig.
        Readonly. Whether this configuration is sensitive, i.e. contains information such as passwords, which might affect how the value of this configuration might be shared by the caller.  Available since v14.

        :return: The sensitive of this ApiConfig.
        :rtype: bool
        """
        return self._sensitive

    @sensitive.setter
    def sensitive(self, sensitive):
        """
        Sets the sensitive of this ApiConfig.
        Readonly. Whether this configuration is sensitive, i.e. contains information such as passwords, which might affect how the value of this configuration might be shared by the caller.  Available since v14.

        :param sensitive: The sensitive of this ApiConfig.
        :type: bool
        """

        self._sensitive = sensitive

    @property
    def validation_state(self):
        """
        Gets the validation_state of this ApiConfig.
        Readonly. Requires \"full\" view. State of the configuration parameter after validation.

        :return: The validation_state of this ApiConfig.
        :rtype: ValidationState
        """
        return self._validation_state

    @validation_state.setter
    def validation_state(self, validation_state):
        """
        Sets the validation_state of this ApiConfig.
        Readonly. Requires \"full\" view. State of the configuration parameter after validation.

        :param validation_state: The validation_state of this ApiConfig.
        :type: ValidationState
        """

        self._validation_state = validation_state

    @property
    def validation_message(self):
        """
        Gets the validation_message of this ApiConfig.
        Readonly. Requires \"full\" view. A message explaining the parameter's validation state.

        :return: The validation_message of this ApiConfig.
        :rtype: str
        """
        return self._validation_message

    @validation_message.setter
    def validation_message(self, validation_message):
        """
        Sets the validation_message of this ApiConfig.
        Readonly. Requires \"full\" view. A message explaining the parameter's validation state.

        :param validation_message: The validation_message of this ApiConfig.
        :type: str
        """

        self._validation_message = validation_message

    @property
    def validation_warnings_suppressed(self):
        """
        Gets the validation_warnings_suppressed of this ApiConfig.
        Readonly. Requires \"full\" view. Whether validation warnings associated with this parameter are suppressed. In general, suppressed validation warnings are hidden in the Cloudera Manager UI. Configurations that do not produce warnings will not contain this field.

        :return: The validation_warnings_suppressed of this ApiConfig.
        :rtype: bool
        """
        return self._validation_warnings_suppressed

    @validation_warnings_suppressed.setter
    def validation_warnings_suppressed(self, validation_warnings_suppressed):
        """
        Sets the validation_warnings_suppressed of this ApiConfig.
        Readonly. Requires \"full\" view. Whether validation warnings associated with this parameter are suppressed. In general, suppressed validation warnings are hidden in the Cloudera Manager UI. Configurations that do not produce warnings will not contain this field.

        :param validation_warnings_suppressed: The validation_warnings_suppressed of this ApiConfig.
        :type: bool
        """

        self._validation_warnings_suppressed = validation_warnings_suppressed

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
