# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiBatchRequestElement(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'method': 'HTTPMethod',
        'url': 'str',
        'body': 'object',
        'content_type': 'str',
        'accept_type': 'str'
    }

    attribute_map = {
        'method': 'method',
        'url': 'url',
        'body': 'body',
        'content_type': 'contentType',
        'accept_type': 'acceptType'
    }

    def __init__(self, method=None, url=None, body=None, content_type=None, accept_type=None):
        """
        ApiBatchRequestElement - a model defined in Swagger
        """

        self._method = None
        self._url = None
        self._body = None
        self._content_type = None
        self._accept_type = None

        if method is not None:
          self.method = method
        if url is not None:
          self.url = url
        if body is not None:
          self.body = body
        if content_type is not None:
          self.content_type = content_type
        if accept_type is not None:
          self.accept_type = accept_type

    @property
    def method(self):
        """
        Gets the method of this ApiBatchRequestElement.
        The type of request (e.g. POST, GET, etc.).

        :return: The method of this ApiBatchRequestElement.
        :rtype: HTTPMethod
        """
        return self._method

    @method.setter
    def method(self, method):
        """
        Sets the method of this ApiBatchRequestElement.
        The type of request (e.g. POST, GET, etc.).

        :param method: The method of this ApiBatchRequestElement.
        :type: HTTPMethod
        """

        self._method = method

    @property
    def url(self):
        """
        Gets the url of this ApiBatchRequestElement.
        The URL of the request. Must not have a scheme, host, or port. The path should be prefixed with \"/api/\", and should include path and query parameters.

        :return: The url of this ApiBatchRequestElement.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this ApiBatchRequestElement.
        The URL of the request. Must not have a scheme, host, or port. The path should be prefixed with \"/api/\", and should include path and query parameters.

        :param url: The url of this ApiBatchRequestElement.
        :type: str
        """

        self._url = url

    @property
    def body(self):
        """
        Gets the body of this ApiBatchRequestElement.
        Optional body of the request. Must be serialized in accordance with #getContentType(). For application/json, use com.cloudera.api.ApiObjectMapper.

        :return: The body of this ApiBatchRequestElement.
        :rtype: object
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this ApiBatchRequestElement.
        Optional body of the request. Must be serialized in accordance with #getContentType(). For application/json, use com.cloudera.api.ApiObjectMapper.

        :param body: The body of this ApiBatchRequestElement.
        :type: object
        """

        self._body = body

    @property
    def content_type(self):
        """
        Gets the content_type of this ApiBatchRequestElement.
        Content-Type header of the request element. If unset, the element will be treated as if the wildcard type had been specified unless it has a body, in which case it will fall back to application/json.

        :return: The content_type of this ApiBatchRequestElement.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this ApiBatchRequestElement.
        Content-Type header of the request element. If unset, the element will be treated as if the wildcard type had been specified unless it has a body, in which case it will fall back to application/json.

        :param content_type: The content_type of this ApiBatchRequestElement.
        :type: str
        """

        self._content_type = content_type

    @property
    def accept_type(self):
        """
        Gets the accept_type of this ApiBatchRequestElement.
        Accept header of the request element. The response body (if it exists) will be in this representation. If unset, the element will be treated as if the wildcard type had been requested.

        :return: The accept_type of this ApiBatchRequestElement.
        :rtype: str
        """
        return self._accept_type

    @accept_type.setter
    def accept_type(self, accept_type):
        """
        Sets the accept_type of this ApiBatchRequestElement.
        Accept header of the request element. The response body (if it exists) will be in this representation. If unset, the element will be treated as if the wildcard type had been requested.

        :param accept_type: The accept_type of this ApiBatchRequestElement.
        :type: str
        """

        self._accept_type = accept_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiBatchRequestElement):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
