# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ProcessResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_config_file(self, cluster_name, config_file_name, role_name, service_name, **kwargs):
        """
        Returns the contents of the specified config file.
        Returns the contents of the specified config file. A multi-level file name (e.g. hadoop-conf/hdfs-site.xml) is acceptable here.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_config_file(cluster_name, config_file_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str config_file_name: Name of the config file to get. (required)
        :param str role_name:  (required)
        :param str service_name:  (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_config_file_with_http_info(cluster_name, config_file_name, role_name, service_name, **kwargs)
        else:
            (data) = self.get_config_file_with_http_info(cluster_name, config_file_name, role_name, service_name, **kwargs)
            return data

    def get_config_file_with_http_info(self, cluster_name, config_file_name, role_name, service_name, **kwargs):
        """
        Returns the contents of the specified config file.
        Returns the contents of the specified config file. A multi-level file name (e.g. hadoop-conf/hdfs-site.xml) is acceptable here.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_config_file_with_http_info(cluster_name, config_file_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str config_file_name: Name of the config file to get. (required)
        :param str role_name:  (required)
        :param str service_name:  (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'config_file_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_config_file`")
        # verify the required parameter 'config_file_name' is set
        if ('config_file_name' not in params) or (params['config_file_name'] is None):
            raise ValueError("Missing the required parameter `config_file_name` when calling `get_config_file`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_config_file`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_config_file`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'config_file_name' in params:
            path_params['configFileName'] = params['config_file_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/octet-stream'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/process/configFiles/{configFileName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_process(self, cluster_name, role_name, service_name, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_process(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name:  (required)
        :param str service_name:  (required)
        :return: ApiProcess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_process_with_http_info(cluster_name, role_name, service_name, **kwargs)
        else:
            (data) = self.get_process_with_http_info(cluster_name, role_name, service_name, **kwargs)
            return data

    def get_process_with_http_info(self, cluster_name, role_name, service_name, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_process_with_http_info(cluster_name, role_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str role_name:  (required)
        :param str service_name:  (required)
        :return: ApiProcess
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'role_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_process`")
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_process`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_process`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roles/{roleName}/process', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiProcess',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
