# viaConstructor

OpenSource CAM-Tool to generate gCode from DXF-Files

!!!!!!! beta - version !!!!!!!

## Features:

    * 3D-Preview
    * Headless-Support to generate gcode on the console
    * the preview of the milling path is generated by the original gcode data using a simple gcode-interpreter
    * the offsets are calculated internaly, no offset-support in the cnc controller is needed
    * the gcode-interpreter can be used externaly to generate thumbnails and previews
    * the dxf-reader can be used externaly to generate thumbnails and previews
    * automatic offset finder (inside/outside)
    * automatig order of multiple parts (nearest first)
    * nested parts will milled in the right order (inside parts first)

![viaconstructor](https://raw.githubusercontent.com/multigcs/viaconstructor/main/docs/viaconstructor.png)

## quikstart

### install with pip
```
pip3 install viaconstructor
```

### get code
```
git clone git@github.com:multigcs/viaconstructor.git
cd viaconstructor
pip3 install -r requirements.txt
```

### start viaconstructor
```
./bin/viaconstructor tests/data/simple.dxf
```

### thumbnail generator: gcode to jpg
```
./bin/gcodepreview tests/data/simple.ngc -o tests/data/simple.jpg
```

### thumbnail generator: dxf to jpg
```
./bin/dxfpreview tests/data/simple.dxf -o tests/data/simple.jpg
```

![gcodepreview](https://raw.githubusercontent.com/multigcs/viaconstructor/main/docs/gcodepreview.png)

![dxfpreview](https://raw.githubusercontent.com/multigcs/viaconstructor/main/docs/dxfpreview.png)


![helix](https://raw.githubusercontent.com/multigcs/viaconstructor/main/docs/helix-true.png)
![overcut](https://raw.githubusercontent.com/multigcs/viaconstructor/main/docs/overcut-true.png)
![tabs](https://raw.githubusercontent.com/multigcs/viaconstructor/main/docs/tabs-true.png)
![pockets](https://raw.githubusercontent.com/multigcs/viaconstructor/main/docs/pockets-true.png)
