"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../lib");
describe('HttpStage', () => {
    test('default', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'Api', {
            createDefaultStage: false,
        });
        new lib_1.HttpStage(stack, 'Stage', {
            httpApi: api,
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Stage', {
            ApiId: stack.resolve(api.httpApiId),
            StageName: '$default',
        });
    });
    test('import', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'Api', {
            createDefaultStage: false,
        });
        const stage = new lib_1.HttpStage(stack, 'Stage', {
            httpApi: api,
        });
        const imported = lib_1.HttpStage.fromStageName(stack, 'Import', stage.stageName);
        expect(imported.stageName).toEqual(stage.stageName);
    });
    test('url returns the correct path', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'Api', {
            createDefaultStage: false,
        });
        const defaultStage = new lib_1.HttpStage(stack, 'DefaultStage', {
            httpApi: api,
        });
        const betaStage = new lib_1.HttpStage(stack, 'BetaStage', {
            httpApi: api,
            stageName: 'beta',
        });
        expect(defaultStage.url.endsWith('/')).toBe(true);
        expect(betaStage.url.endsWith('/')).toBe(false);
    });
});
//# sourceMappingURL=data:application/json;base64,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