"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../lib");
describe('HttpRoute', () => {
    test('default', () => {
        const stack = new core_1.Stack();
        const httpApi = new lib_1.HttpApi(stack, 'HttpApi');
        new lib_1.HttpRoute(stack, 'HttpRoute', {
            httpApi,
            integration: new DummyIntegration(),
            routeKey: lib_1.HttpRouteKey.with('/books', lib_1.HttpMethod.GET),
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Route', {
            ApiId: stack.resolve(httpApi.httpApiId),
            RouteKey: 'GET /books',
            Target: {
                'Fn::Join': [
                    '',
                    [
                        'integrations/',
                        {
                            Ref: 'HttpRouteHttpRouteIntegration6EE0FE47',
                        },
                    ],
                ],
            },
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Integration', {
            ApiId: stack.resolve(httpApi.httpApiId),
        });
    });
    test('integration is configured correctly', () => {
        const stack = new core_1.Stack();
        const httpApi = new lib_1.HttpApi(stack, 'HttpApi');
        new lib_1.HttpRoute(stack, 'HttpRoute', {
            httpApi,
            integration: new DummyIntegration(),
            routeKey: lib_1.HttpRouteKey.with('/books', lib_1.HttpMethod.GET),
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Integration', {
            ApiId: stack.resolve(httpApi.httpApiId),
            IntegrationType: 'HTTP_PROXY',
            PayloadFormatVersion: '2.0',
            IntegrationUri: 'some-uri',
        });
    });
    test('throws when path not start with /', () => {
        const stack = new core_1.Stack();
        const httpApi = new lib_1.HttpApi(stack, 'HttpApi');
        expect(() => new lib_1.HttpRoute(stack, 'HttpRoute', {
            httpApi,
            integration: new DummyIntegration(),
            routeKey: lib_1.HttpRouteKey.with('books', lib_1.HttpMethod.GET),
        })).toThrowError(/path must always start with a "\/" and not end with a "\/"/);
    });
    test('throws when path ends with /', () => {
        const stack = new core_1.Stack();
        const httpApi = new lib_1.HttpApi(stack, 'HttpApi');
        expect(() => new lib_1.HttpRoute(stack, 'HttpRoute', {
            httpApi,
            integration: new DummyIntegration(),
            routeKey: lib_1.HttpRouteKey.with('/books/', lib_1.HttpMethod.GET),
        })).toThrowError(/path must always start with a "\/" and not end with a "\/"/);
    });
});
class DummyIntegration {
    bind() {
        return {
            type: lib_1.HttpIntegrationType.HTTP_PROXY,
            payloadFormatVersion: lib_1.PayloadFormatVersion.VERSION_2_0,
            uri: 'some-uri',
            method: lib_1.HttpMethod.DELETE,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGUudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJvdXRlLnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnQ0FBOEI7QUFDOUIsd0NBQXNDO0FBQ3RDLG1DQUMwQztBQUUxQyxRQUFRLENBQUMsV0FBVyxFQUFFLEdBQUcsRUFBRTtJQUN6QixJQUFJLENBQUMsU0FBUyxFQUFFLEdBQUcsRUFBRTtRQUNuQixNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssRUFBRSxDQUFDO1FBQzFCLE1BQU0sT0FBTyxHQUFHLElBQUksYUFBTyxDQUFDLEtBQUssRUFBRSxTQUFTLENBQUMsQ0FBQztRQUU5QyxJQUFJLGVBQVMsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO1lBQ2hDLE9BQU87WUFDUCxXQUFXLEVBQUUsSUFBSSxnQkFBZ0IsRUFBRTtZQUNuQyxRQUFRLEVBQUUsa0JBQVksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLGdCQUFVLENBQUMsR0FBRyxDQUFDO1NBQ3RELENBQUMsQ0FBQztRQUVILE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxjQUFjLENBQUMsMEJBQTBCLEVBQUU7WUFDdkQsS0FBSyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQztZQUN2QyxRQUFRLEVBQUUsWUFBWTtZQUN0QixNQUFNLEVBQUU7Z0JBQ04sVUFBVSxFQUFFO29CQUNWLEVBQUU7b0JBQ0Y7d0JBQ0UsZUFBZTt3QkFDZjs0QkFDRSxHQUFHLEVBQUUsdUNBQXVDO3lCQUM3QztxQkFDRjtpQkFDRjthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLGNBQWMsQ0FBQyxnQ0FBZ0MsRUFBRTtZQUM3RCxLQUFLLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDO1NBQ3hDLENBQUMsQ0FBQztJQUNMLENBQUMsQ0FBQyxDQUFDO0lBRUgsSUFBSSxDQUFDLHFDQUFxQyxFQUFFLEdBQUcsRUFBRTtRQUMvQyxNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssRUFBRSxDQUFDO1FBQzFCLE1BQU0sT0FBTyxHQUFHLElBQUksYUFBTyxDQUFDLEtBQUssRUFBRSxTQUFTLENBQUMsQ0FBQztRQUU5QyxJQUFJLGVBQVMsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO1lBQ2hDLE9BQU87WUFDUCxXQUFXLEVBQUUsSUFBSSxnQkFBZ0IsRUFBRTtZQUNuQyxRQUFRLEVBQUUsa0JBQVksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLGdCQUFVLENBQUMsR0FBRyxDQUFDO1NBQ3RELENBQUMsQ0FBQztRQUVILE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxjQUFjLENBQUMsZ0NBQWdDLEVBQUU7WUFDN0QsS0FBSyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQztZQUN2QyxlQUFlLEVBQUUsWUFBWTtZQUM3QixvQkFBb0IsRUFBRSxLQUFLO1lBQzNCLGNBQWMsRUFBRSxVQUFVO1NBQzNCLENBQUMsQ0FBQztJQUNMLENBQUMsQ0FBQyxDQUFDO0lBRUgsSUFBSSxDQUFDLG1DQUFtQyxFQUFFLEdBQUcsRUFBRTtRQUM3QyxNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssRUFBRSxDQUFDO1FBQzFCLE1BQU0sT0FBTyxHQUFHLElBQUksYUFBTyxDQUFDLEtBQUssRUFBRSxTQUFTLENBQUMsQ0FBQztRQUU5QyxNQUFNLENBQUMsR0FBRyxFQUFFLENBQUMsSUFBSSxlQUFTLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRTtZQUM3QyxPQUFPO1lBQ1AsV0FBVyxFQUFFLElBQUksZ0JBQWdCLEVBQUU7WUFDbkMsUUFBUSxFQUFFLGtCQUFZLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxnQkFBVSxDQUFDLEdBQUcsQ0FBQztTQUNyRCxDQUFDLENBQUMsQ0FBQyxZQUFZLENBQUMsNERBQTRELENBQUMsQ0FBQztJQUNqRixDQUFDLENBQUMsQ0FBQztJQUVILElBQUksQ0FBQyw4QkFBOEIsRUFBRSxHQUFHLEVBQUU7UUFDeEMsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLEVBQUUsQ0FBQztRQUMxQixNQUFNLE9BQU8sR0FBRyxJQUFJLGFBQU8sQ0FBQyxLQUFLLEVBQUUsU0FBUyxDQUFDLENBQUM7UUFFOUMsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDLElBQUksZUFBUyxDQUFDLEtBQUssRUFBRSxXQUFXLEVBQUU7WUFDN0MsT0FBTztZQUNQLFdBQVcsRUFBRSxJQUFJLGdCQUFnQixFQUFFO1lBQ25DLFFBQVEsRUFBRSxrQkFBWSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsZ0JBQVUsQ0FBQyxHQUFHLENBQUM7U0FDdkQsQ0FBQyxDQUFDLENBQUMsWUFBWSxDQUFDLDREQUE0RCxDQUFDLENBQUM7SUFDakYsQ0FBQyxDQUFDLENBQUM7QUFFTCxDQUFDLENBQUMsQ0FBQztBQUVILE1BQU0sZ0JBQWdCO0lBQ2IsSUFBSTtRQUNULE9BQVE7WUFDTixJQUFJLEVBQUUseUJBQW1CLENBQUMsVUFBVTtZQUNwQyxvQkFBb0IsRUFBRSwwQkFBb0IsQ0FBQyxXQUFXO1lBQ3RELEdBQUcsRUFBRSxVQUFVO1lBQ2YsTUFBTSxFQUFFLGdCQUFVLENBQUMsTUFBTTtTQUMxQixDQUFDO0lBQ0osQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICdAYXdzLWNkay9hc3NlcnQvamVzdCc7XG5pbXBvcnQgeyBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgSHR0cEFwaSwgSHR0cEludGVncmF0aW9uVHlwZSwgSHR0cE1ldGhvZCwgSHR0cFJvdXRlLCBIdHRwUm91dGVJbnRlZ3JhdGlvbkNvbmZpZywgSHR0cFJvdXRlS2V5LCBJSHR0cFJvdXRlSW50ZWdyYXRpb24sXG4gIFBheWxvYWRGb3JtYXRWZXJzaW9uIH0gZnJvbSAnLi4vLi4vbGliJztcblxuZGVzY3JpYmUoJ0h0dHBSb3V0ZScsICgpID0+IHtcbiAgdGVzdCgnZGVmYXVsdCcsICgpID0+IHtcbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuICAgIGNvbnN0IGh0dHBBcGkgPSBuZXcgSHR0cEFwaShzdGFjaywgJ0h0dHBBcGknKTtcblxuICAgIG5ldyBIdHRwUm91dGUoc3RhY2ssICdIdHRwUm91dGUnLCB7XG4gICAgICBodHRwQXBpLFxuICAgICAgaW50ZWdyYXRpb246IG5ldyBEdW1teUludGVncmF0aW9uKCksXG4gICAgICByb3V0ZUtleTogSHR0cFJvdXRlS2V5LndpdGgoJy9ib29rcycsIEh0dHBNZXRob2QuR0VUKSxcbiAgICB9KTtcblxuICAgIGV4cGVjdChzdGFjaykudG9IYXZlUmVzb3VyY2UoJ0FXUzo6QXBpR2F0ZXdheVYyOjpSb3V0ZScsIHtcbiAgICAgIEFwaUlkOiBzdGFjay5yZXNvbHZlKGh0dHBBcGkuaHR0cEFwaUlkKSxcbiAgICAgIFJvdXRlS2V5OiAnR0VUIC9ib29rcycsXG4gICAgICBUYXJnZXQ6IHtcbiAgICAgICAgJ0ZuOjpKb2luJzogW1xuICAgICAgICAgICcnLFxuICAgICAgICAgIFtcbiAgICAgICAgICAgICdpbnRlZ3JhdGlvbnMvJyxcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgUmVmOiAnSHR0cFJvdXRlSHR0cFJvdXRlSW50ZWdyYXRpb242RUUwRkU0NycsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIF0sXG4gICAgICAgIF0sXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgZXhwZWN0KHN0YWNrKS50b0hhdmVSZXNvdXJjZSgnQVdTOjpBcGlHYXRld2F5VjI6OkludGVncmF0aW9uJywge1xuICAgICAgQXBpSWQ6IHN0YWNrLnJlc29sdmUoaHR0cEFwaS5odHRwQXBpSWQpLFxuICAgIH0pO1xuICB9KTtcblxuICB0ZXN0KCdpbnRlZ3JhdGlvbiBpcyBjb25maWd1cmVkIGNvcnJlY3RseScsICgpID0+IHtcbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuICAgIGNvbnN0IGh0dHBBcGkgPSBuZXcgSHR0cEFwaShzdGFjaywgJ0h0dHBBcGknKTtcblxuICAgIG5ldyBIdHRwUm91dGUoc3RhY2ssICdIdHRwUm91dGUnLCB7XG4gICAgICBodHRwQXBpLFxuICAgICAgaW50ZWdyYXRpb246IG5ldyBEdW1teUludGVncmF0aW9uKCksXG4gICAgICByb3V0ZUtleTogSHR0cFJvdXRlS2V5LndpdGgoJy9ib29rcycsIEh0dHBNZXRob2QuR0VUKSxcbiAgICB9KTtcblxuICAgIGV4cGVjdChzdGFjaykudG9IYXZlUmVzb3VyY2UoJ0FXUzo6QXBpR2F0ZXdheVYyOjpJbnRlZ3JhdGlvbicsIHtcbiAgICAgIEFwaUlkOiBzdGFjay5yZXNvbHZlKGh0dHBBcGkuaHR0cEFwaUlkKSxcbiAgICAgIEludGVncmF0aW9uVHlwZTogJ0hUVFBfUFJPWFknLFxuICAgICAgUGF5bG9hZEZvcm1hdFZlcnNpb246ICcyLjAnLFxuICAgICAgSW50ZWdyYXRpb25Vcmk6ICdzb21lLXVyaScsXG4gICAgfSk7XG4gIH0pO1xuXG4gIHRlc3QoJ3Rocm93cyB3aGVuIHBhdGggbm90IHN0YXJ0IHdpdGggLycsICgpID0+IHtcbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuICAgIGNvbnN0IGh0dHBBcGkgPSBuZXcgSHR0cEFwaShzdGFjaywgJ0h0dHBBcGknKTtcblxuICAgIGV4cGVjdCgoKSA9PiBuZXcgSHR0cFJvdXRlKHN0YWNrLCAnSHR0cFJvdXRlJywge1xuICAgICAgaHR0cEFwaSxcbiAgICAgIGludGVncmF0aW9uOiBuZXcgRHVtbXlJbnRlZ3JhdGlvbigpLFxuICAgICAgcm91dGVLZXk6IEh0dHBSb3V0ZUtleS53aXRoKCdib29rcycsIEh0dHBNZXRob2QuR0VUKSxcbiAgICB9KSkudG9UaHJvd0Vycm9yKC9wYXRoIG11c3QgYWx3YXlzIHN0YXJ0IHdpdGggYSBcIlxcL1wiIGFuZCBub3QgZW5kIHdpdGggYSBcIlxcL1wiLyk7XG4gIH0pO1xuXG4gIHRlc3QoJ3Rocm93cyB3aGVuIHBhdGggZW5kcyB3aXRoIC8nLCAoKSA9PiB7XG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcbiAgICBjb25zdCBodHRwQXBpID0gbmV3IEh0dHBBcGkoc3RhY2ssICdIdHRwQXBpJyk7XG5cbiAgICBleHBlY3QoKCkgPT4gbmV3IEh0dHBSb3V0ZShzdGFjaywgJ0h0dHBSb3V0ZScsIHtcbiAgICAgIGh0dHBBcGksXG4gICAgICBpbnRlZ3JhdGlvbjogbmV3IER1bW15SW50ZWdyYXRpb24oKSxcbiAgICAgIHJvdXRlS2V5OiBIdHRwUm91dGVLZXkud2l0aCgnL2Jvb2tzLycsIEh0dHBNZXRob2QuR0VUKSxcbiAgICB9KSkudG9UaHJvd0Vycm9yKC9wYXRoIG11c3QgYWx3YXlzIHN0YXJ0IHdpdGggYSBcIlxcL1wiIGFuZCBub3QgZW5kIHdpdGggYSBcIlxcL1wiLyk7XG4gIH0pO1xuXG59KTtcblxuY2xhc3MgRHVtbXlJbnRlZ3JhdGlvbiBpbXBsZW1lbnRzIElIdHRwUm91dGVJbnRlZ3JhdGlvbiB7XG4gIHB1YmxpYyBiaW5kKCk6IEh0dHBSb3V0ZUludGVncmF0aW9uQ29uZmlnIHtcbiAgICByZXR1cm4gIHtcbiAgICAgIHR5cGU6IEh0dHBJbnRlZ3JhdGlvblR5cGUuSFRUUF9QUk9YWSxcbiAgICAgIHBheWxvYWRGb3JtYXRWZXJzaW9uOiBQYXlsb2FkRm9ybWF0VmVyc2lvbi5WRVJTSU9OXzJfMCxcbiAgICAgIHVyaTogJ3NvbWUtdXJpJyxcbiAgICAgIG1ldGhvZDogSHR0cE1ldGhvZC5ERUxFVEUsXG4gICAgfTtcbiAgfVxufSJdfQ==