"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../../lib");
describe('LambdaProxyIntegration', () => {
    test('default', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'HttpApi');
        const fooFn = fooFunction(stack, 'Fn');
        new lib_1.HttpRoute(stack, 'LambdaProxyRoute', {
            httpApi: api,
            integration: new lib_1.LambdaProxyIntegration({
                handler: fooFn,
            }),
            routeKey: lib_1.HttpRouteKey.with('/pets'),
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Integration', {
            IntegrationType: 'AWS_PROXY',
            IntegrationUri: stack.resolve(fooFn.functionArn),
            PayloadFormatVersion: '2.0',
        });
    });
    test('payloadFormatVersion selection', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'HttpApi');
        new lib_1.HttpRoute(stack, 'LambdaProxyRoute', {
            httpApi: api,
            integration: new lib_1.LambdaProxyIntegration({
                handler: fooFunction(stack, 'Fn'),
                payloadFormatVersion: lib_1.PayloadFormatVersion.VERSION_1_0,
            }),
            routeKey: lib_1.HttpRouteKey.with('/pets'),
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Integration', {
            PayloadFormatVersion: '1.0',
        });
    });
});
function fooFunction(stack, id) {
    return new aws_lambda_1.Function(stack, id, {
        code: aws_lambda_1.Code.fromInline('foo'),
        runtime: aws_lambda_1.Runtime.NODEJS_12_X,
        handler: 'index.handler',
    });
}
//# sourceMappingURL=data:application/json;base64,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