"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const acm = require("@aws-cdk/aws-certificatemanager");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-http-proxy');
const handler = new lambda.Function(stack, 'echohandler', {
    runtime: lambda.Runtime.NODEJS_12_X,
    handler: 'index.handler',
    code: new lambda.InlineCode('exports.handler = async function(event, context) { return { statusCode: 200, headers: { "content-type": "application/json"  }, body: JSON.stringify(event) }; };'),
});
const certArn = 'arn:aws:acm:us-east-1:111111111111:certificate';
const domainName = 'apigv2.demo.com';
const dn = new lib_1.DomainName(stack, 'DN', {
    domainName,
    certificate: acm.Certificate.fromCertificateArn(stack, 'cert', certArn),
});
const prodApi = new lib_1.HttpApi(stack, 'HttpProxyProdApi', {
    defaultIntegration: new lib_1.LambdaProxyIntegration({ handler }),
    // https://${dn.domainName} goes to prodApi $default stage
    defaultDomainMapping: {
        domainName: dn,
        mappingKey: '/',
    },
});
const betaApi = new lib_1.HttpApi(stack, 'HttpProxyBetaApi', {
    defaultIntegration: new lib_1.LambdaProxyIntegration({ handler }),
    // https://${dn.domainName}/beta goes to betaApi $default stage
    defaultDomainMapping: {
        domainName: dn,
        mappingKey: 'beta',
    },
});
prodApi.addStage('testing', {
    stageName: 'testing',
    autoDeploy: true,
    // https://${dn.domainName}/testing goes to prodApi testing stage
    domainMapping: {
        domainName: dn,
        mappingKey: 'testing',
    },
});
new core_1.CfnOutput(stack, 'RegionalDomainName', { value: dn.regionalDomainName });
new core_1.CfnOutput(stack, 'DomainName', { value: dn.domainName });
new core_1.CfnOutput(stack, 'CustomUDomainURL', { value: `https://${dn.domainName}` });
new core_1.CfnOutput(stack, 'ProdApiEndpoint', { value: prodApi.url });
new core_1.CfnOutput(stack, 'BetaApiEndpoint', { value: betaApi.url });
new core_1.CfnOutput(stack, 'Region', { value: core_1.Stack.of(stack).region });
//# sourceMappingURL=data:application/json;base64,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