"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const aws_certificatemanager_1 = require("@aws-cdk/aws-certificatemanager");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../lib");
const domainName = 'example.com';
const certArn = 'arn:aws:acm:us-east-1:111111111111:certificate';
describe('ApiMapping', () => {
    test('default stage', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'Api');
        const dn = new lib_1.DomainName(stack, 'DomainName', {
            domainName,
            certificate: aws_certificatemanager_1.Certificate.fromCertificateArn(stack, 'cert', certArn),
        });
        new lib_1.HttpApiMapping(stack, 'Mapping', {
            api,
            domainName: dn,
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::ApiMapping', {
            ApiId: {
                Ref: 'ApiF70053CD',
            },
            DomainName: 'example.com',
            Stage: '$default',
        });
    });
    test('beta stage mapping', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'Api', {
            createDefaultStage: false,
        });
        const beta = api.addStage('beta', {
            stageName: 'beta',
        });
        const dn = new lib_1.DomainName(stack, 'DomainName', {
            domainName,
            certificate: aws_certificatemanager_1.Certificate.fromCertificateArn(stack, 'cert', certArn),
        });
        new lib_1.HttpApiMapping(stack, 'Mapping', {
            api,
            domainName: dn,
            stage: beta,
            apiMappingKey: 'beta',
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::ApiMapping', {
            ApiId: {
                Ref: 'ApiF70053CD',
            },
            DomainName: 'example.com',
            Stage: 'beta',
            ApiMappingKey: 'beta',
        });
    });
    test('import mapping', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'Api');
        const dn = new lib_1.DomainName(stack, 'DomainName', {
            domainName,
            certificate: aws_certificatemanager_1.Certificate.fromCertificateArn(stack, 'cert', certArn),
        });
        const mapping = new lib_1.HttpApiMapping(stack, 'Mapping', {
            api,
            domainName: dn,
            apiMappingKey: '/',
        });
        const imported = lib_1.HttpApiMapping.fromHttpApiMappingAttributes(stack, 'ImportedMapping', {
            apiMappingId: mapping.apiMappingId,
        });
        expect(imported.apiMappingId).toEqual(mapping.apiMappingId);
    });
});
//# sourceMappingURL=data:application/json;base64,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