import { Construct, Resource } from '@aws-cdk/core';
import { CommonStageOptions, IDomainName, IStage } from '../common';
import { IHttpApi } from './api';
/**
 * Represents the HttpStage
 */
export interface IHttpStage extends IStage {
}
/**
 * Options to create a new stage for an HTTP API.
 */
export interface HttpStageOptions extends CommonStageOptions {
    /**
     * The options for custom domain and api mapping
     *
     * @default - no custom domain and api mapping configuration
     */
    readonly domainMapping?: DomainMappingOptions;
}
/**
 * Properties to initialize an instance of `HttpStage`.
 */
export interface HttpStageProps extends HttpStageOptions {
    /**
     * The HTTP API to which this stage is associated.
     */
    readonly httpApi: IHttpApi;
}
/**
 * Options for defaultDomainMapping
 */
export interface DefaultDomainMappingOptions {
    /**
     * The domain name for the mapping
     *
     */
    readonly domainName: IDomainName;
    /**
     * The API mapping key. Specify '/' for the root path mapping.
     *
     */
    readonly mappingKey: string;
}
/**
 * Options for DomainMapping
 */
export interface DomainMappingOptions extends DefaultDomainMappingOptions {
    /**
     * The API Stage
     *
     * @default - the $default stage
     */
    readonly stage?: IStage;
}
/**
 * Represents a stage where an instance of the API is deployed.
 * @resource AWS::ApiGatewayV2::Stage
 */
export declare class HttpStage extends Resource implements IStage {
    /**
     * Import an existing stage into this CDK app.
     */
    static fromStageName(scope: Construct, id: string, stageName: string): IStage;
    readonly stageName: string;
    private httpApi;
    constructor(scope: Construct, id: string, props: HttpStageProps);
    /**
     * The URL to this stage.
     */
    get url(): string;
}
