"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaProxyIntegration = void 0;
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const integration_1 = require("../integration");
/**
 * The Lambda Proxy integration resource for HTTP API
 */
class LambdaProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(route) {
        var _a, _b;
        this.props.handler.addPermission(`${route.node.uniqueId}-Permission`, {
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.httpApiId,
                resourceName: `*/*${(_a = route.path) !== null && _a !== void 0 ? _a : ''}`,
            }),
        });
        return {
            type: integration_1.HttpIntegrationType.LAMBDA_PROXY,
            uri: this.props.handler.functionArn,
            payloadFormatVersion: (_b = this.props.payloadFormatVersion) !== null && _b !== void 0 ? _b : integration_1.PayloadFormatVersion.VERSION_2_0,
        };
    }
}
exports.LambdaProxyIntegration = LambdaProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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