"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpProxyIntegration = void 0;
const integration_1 = require("../integration");
const route_1 = require("../route");
/**
 * The HTTP Proxy integration resource for HTTP API
 */
class HttpProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(_) {
        var _a;
        return {
            method: (_a = this.props.method) !== null && _a !== void 0 ? _a : route_1.HttpMethod.ANY,
            payloadFormatVersion: integration_1.PayloadFormatVersion.VERSION_1_0,
            type: integration_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.props.url,
        };
    }
}
exports.HttpProxyIntegration = HttpProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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