"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIntegration = exports.PayloadFormatVersion = exports.HttpIntegrationType = void 0;
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Supported integration types
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    /**
     * Integration type is a Lambda proxy
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["LAMBDA_PROXY"] = "AWS_PROXY";
    /**
     * Integration type is an HTTP proxy
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
})(HttpIntegrationType = exports.HttpIntegrationType || (exports.HttpIntegrationType = {}));
/**
 * Payload format version for lambda proxy integration
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 */
class PayloadFormatVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * A custom payload version.
     * Typically used if there is a version number that the CDK doesn't support yet
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
/** Version 1.0 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/** Version 2.0 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const integ = new apigatewayv2_generated_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.httpApiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            payloadFormatVersion: (_a = props.payloadFormatVersion) === null || _a === void 0 ? void 0 : _a.version,
        });
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,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