"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiMapping = void 0;
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Create a new API mapping for API Gateway HTTP API endpoint.
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class HttpApiMapping extends core_1.Resource {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const apiMappingProps = {
            apiId: props.api.httpApiId,
            domainName: props.domainName.domainName,
            stage: (_b = (_a = props.stage) === null || _a === void 0 ? void 0 : _a.stageName) !== null && _b !== void 0 ? _b : '$default',
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new apigatewayv2_generated_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        this.apiMappingId = resource.ref;
    }
    /**
     * import from API ID
     */
    static fromHttpApiMappingAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.HttpApiMapping = HttpApiMapping;
//# sourceMappingURL=data:application/json;base64,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