# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cc_codechecker', 'cc_codechecker.runners']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0', 'python-semantic-release>=7.24.0,<8.0.0']

entry_points = \
{'console_scripts': ['cc-codechecker = cc_codechecker.codechecker:main']}

setup_kwargs = {
    'name': 'cc-codechecker',
    'version': '0.1.10',
    'description': 'Facilities to manage coding challenges.',
    'long_description': "===========\nCodechecker\n===========\n---------------------------------------\nFacilities to manage coding challenges.\n---------------------------------------\n\n.. image:: https://img.shields.io/pypi/pyversions/cc-codechecker\n    :target: https://pypi.org/project/cc-codechecker/\n    :alt: PyPI - Python Version\n\n.. image:: https://img.shields.io/pypi/v/cc-codechecker\n    :target: https://pypi.org/project/cc-codechecker/\n    :alt: PyPI\n\n.. image:: https://img.shields.io/pypi/dm/cc-codechecker\n    :target: https://pypi.org/project/cc-codechecker/\n    :alt: PyPI - Downloads\n\n.. image:: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white\n    :target: https://github.com/pre-commit/pre-commit\n    :alt: pre-commit\n\n.. image:: https://results.pre-commit.ci/badge/github/Daniele-Tentoni/cc-codechecker/main.svg\n    :target: https://results.pre-commit.ci/latest/github/Daniele-Tentoni/cc-codechecker/main\n    :alt: pre-commit.ci status\n\n.. image:: https://img.shields.io/badge/security-bandit-yellow.svg\n    :target: https://github.com/PyCQA/bandit\n    :alt: Security Status\n\n.. image:: https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336\n    :target: https://pycqa.github.io/isort/\n\n.. image:: https://api.codacy.com/project/badge/Grade/cd570d18e58e45ea832a8031388d112d\n   :alt: Codacy Badge\n   :target: https://app.codacy.com/gh/Daniele-Tentoni/cc-codechecker?utm_source=github.com&utm_medium=referral&utm_content=Daniele-Tentoni/cc-codechecker&utm_campaign=Badge_Grade_Settings\n\n**Table of Contents**:\n\nA. `Purpose`__\n\nB. `Install`__\n\nC. `Usage`__\n\n   1. `Basic example`__\n\n   2. `Advanced example`__\n\nD. `Contributing`__\n\nE. `Complete configuration reference`__\n\n   1. `First level`__\n   2. `Project reference`__\n   3. `Challenge reference`__\n\n__ `Purpose`_\n__ `Install`_\n__ `Usage`_\n__ `Basic example`_\n__ `Advanced example`_\n__ `Contributing`__\n__ `Complete configuration reference`_\n__ `First level`_\n__ `Project reference`_\n__ `Challenge reference`_\n\nPurpose\n=======\n\nUse **codechecker** to manage coding challenge hosted entirely on Github. This have as advantage that every one can apply to the challenge easily, we can use the already implemented Github social coding suites like issues, pull requests, pages and actions and users are invited to populate their Github profiles with repository that shows their skills.\n\nIn 2022, coding challenges are even used to determine what kind of employee companies might hire. Being able to create coding challenges and make them easy to access could mean more potentially developers to admit to a more advanced interview.\n\nOther repository hosting sites are not supported at the moment. Return here in the future or start contributing_.\n\nInstall\n=======\n\nYou can install codechecker using **pip**::\n\n  pip install cc_codechecker\n\nUsage\n=====\n\nUsing codechecker for a coding challenge is very simple.\n\nInit a new challenge inside your current repository using the facility::\n\n  cc_codechecker init\n\nThis command will create a new ``.codechecker.yml`` file inside your root directory. Obv, you can create that file by your own. Then, specify what programming languages you support and how you support them! You can declare, for example:\n\n1. What version of specified language you support (not implemented)\n2. What dialect of specified language you support (not implemented)\n3. How many points you assign for each problem solved (not implemented)\n\nMore features will be added. Return here in the future or start contributing_.\n\n> We enforce the use of ``.`` preceding codechecker files inside challenge repository to make it hidden by default on many know system, to let users focus more and better on the challenge.\n\nWarning! Running init command in a repository that already hold a configuration file return an ``EX_CANTCREATE(73)`` error. To overwrite current configuration, run with the option ``--overwrite-yml``.\n\nBasic example\n~~~~~~~~~~~~~\n\nThe following code can be considered the minimum configuration for a challenge.\n\nFor the simplest example of codechecker use this short configuration::\n\n  challenge: base\n  project: bash\n\nThis represent the following folder structure::\n\n  - <challenge-name>/\n      - bash/\n          - program.sh\n      - .codechecker.yml\n      - README.md\n\nThis basic example shows how to prepare a challenge that supports only **bash** language with only one challenge called **base**. Executing a score keeping command, like `cc_codechecker run`, inside this repo will means:\n\n1. Start collecting points for the challenge *base*\n2. Try to run *bash* program inside *bash* folder without any argument without expecting any output\n3. Give no points to users, commenting only if the challenge was completed or not\n\n> You can use codechecker in tandem with the related Github Action to collect that score file and create a Github Pages landing page for your challenge.\n\nAdvanced example\n~~~~~~~~~~~~~~~~\n\nThe following code is used for a challenge supporting many languages and assigning more points for more difficult challenges.\n\nFor the simplest example of codechecker inside the yaml file write this code::\n\n  # Project definitions (for any challenge declared)\n  projects:\n    # Project with custom folder name\n    - language: 'bash'\n      folder: 'for-shell-lovers'\n\n    # Simple project\n    - language: csharp\n\n  # Challenges definitions\n  challenges:\n    # Simple challenge (doesn't score points)\n    - name: challenge1\n\n    # Challenge with value (score points)\n    - value: 1\n\n    # Challenge that take input from file\n    - name: challenge3\n      argument: input_challenge3.txt\n      result: result_challenge3.txt\n\n    # Challenge that take input from array\n    - name: challenge4\n      arguments: [1, 1]\n      results: [2]\n\n    # Challenge with additional projects\n    - value: 5\n      argument: input_challenge5.txt\n      result: result_challenge5.txt\n      projects: [!csharp]\n\n    # Challenge with additional complex projects\n    - argument: input6.txt\n      result: result6.txt\n      projects: [csharp]\n\nThis configuration means the following folder structure::\n\n  - <challenge-name>-solutions/\n      - input_challenge3.txt\n      - result_challenge3.txt\n      - input_challenge4.txt\n      - result_challenge4.txt\n      - input5.txt\n      - result5.txt\n\n  - <challenge-name>/\n      - for-shell-lovers/\n          - script.sh\n      - csharp/\n          - csharp.csproj\n          - program.cs\n      - .codechecker.yml\n      - readme\n\nThis is a really complex configuration that can be explained as following:\n\n1. Compute the first challenge named challenge1\n   a. Try to execute the project *for-shell-lovers* coded with bash language without any input, without collecting any results\n   b. Try to execute the project *csharp* without any input, without collecting any result\n2. Compute the second challenge that assign 1 points\n   a. If *for-shell-lovers* exit with a successfully result, mark challenge as resolved\n   b. If *csharp* exit with a successfully result, mark challenge as resolved\n   c. If the challenge is marked as resolved, assign points\n3. Compute the third challenge that doesn't assign any points\n   a. Get the content of the file input_challenge3.txt and copy it in the same folder of the project *for-shell-lovers* as input.txt\n   b. If *for-shell-lovers* exit with a successfully result giving as input the current relative path to the copied file, check it's content and if correspond to the contents of the file result_challenge3.txt, mark challenge as resolved\n   c. If *csharp* exit with a successfully result giving as input the current relative path to the copied file, check it's content and if correspond to the contents of the file result_challenge3.txt, mark challenge as resolved\n   d. If the challenge is marked as resolved, assign points\n4. Compute the fourth challenge that doesn't assign any points. This challenge instead giving files as inputs, give data as arguments\n5. Compute the fifth challenge that assign 5 points, without executing csharp project, permitting users to resolve this challenge using only bash language\n6. Compute the sixth challenge that doesn't assign any points only for bash language\n\n:!: The option for excluding or including projects is not implemented yet.\n\nContributing\n============\n\nContributions are welcome! Check out `Contributing Guidelines`_.\n\n.. _Contributing Guidelines: /CONTRIBUTING.rst\n\nComplete configuration reference\n================================\n\nAll features listed here are implemented. This is not a code documentation.\n\nFirst level\n~~~~~~~~~~~\n\nchallenges\n  Define each step of the challenge, assigning to each of them. This is *required* in each configuration.\n\noutput\n  Define the name of the output score file name.\n\nprojects\n  Define the list of projects inside the repository. This is *required* in each configuration.\n  See Project for option reference of this yaml section.\n\nProject reference\n-----------------\n\nlanguage\n  Define the programming language for the project. This is *required* for each project.\n\n  Supported programming languages are:\n\n  * Bash, using ``bash`` (other sh dialect for small things work the same, but are not tested)\n  * CSharp, using ``dotnet``\n\nChallenge reference\n-------------------\n\nDefine a step of the challenge.\n\nIt can assign points to score the attempt.\n\nname\n  Define the name of the challenge. Use in challenge run report.\n\nvalue\n  Points to assign completing the challenge. Don't give value if you don't wan't to evaluate that step.\n\nargument\n  Name of the file to give as input to the challenge. Giving input exclude inputs.\n\nresult\n  Name of the file to give as result checker. Giving result exclude results.\n\narguments\n  Array of items to give as input to the challenge. Giving inputs exclude input.\n\nresults\n  Array of items to give as result checker.\n",
    'author': 'Daniele Tentoni',
    'author_email': 'daniele.tentoni.1996@gmail.com',
    'maintainer': 'Daniele Tentoni',
    'maintainer_email': 'daniele.tentoni.1996@gmail.com',
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10.0,<4.0.0',
}


setup(**setup_kwargs)
