# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['ifnone', 'make_date', 'add_datepart', 'add_lag_features', 'add_lag_percentage_gain_features',
           'add_moving_average_features', 'add_moving_average_percentage_gain_features', 'add_expanding_features',
           'add_trend_features']

# Cell
from typing import *
from fastcore import *
from fastcore.utils import *
from fastcore.script import *
import pandas as pd
import numpy as np

# Cell
def ifnone(a:Any,b:Any)->Any:
    "`a` if `a` is not None, otherwise `b`."
    return b if a is None else a

# Cell
def make_date(df, date_field):
    "Make sure `df[date_field]` is of the right date type."
    field_dtype = df[date_field].dtype
    if isinstance(field_dtype, pd.core.dtypes.dtypes.DatetimeTZDtype):
        field_dtype = np.datetime64
    if not np.issubdtype(field_dtype, np.datetime64):
        df[date_field] = pd.to_datetime(df[date_field], infer_datetime_format=True)

# Cell
def add_datepart(df, field_name, prefix=None, drop=True, time=False):
    "Helper function that adds columns relevant to a date in the column `field_name` of `df`."
    make_date(df, field_name)
    field = df[field_name]
    prefix = ifnone(prefix, re.sub('[Dd]ate$', '', field_name))
    attr = ['Year', 'Month', 'Week', 'Day', 'Dayofweek', 'Dayofyear', 'Is_month_end', 'Is_month_start',
            'Is_quarter_end', 'Is_quarter_start', 'Is_year_end', 'Is_year_start']
    if time: attr = attr + ['Hour', 'Minute', 'Second']
    # Pandas removed `dt.week` in v1.1.10
    week = field.dt.isocalendar().week.astype(field.dt.day.dtype) if hasattr(field.dt, 'isocalendar') else field.dt.week
    for n in attr: df[prefix + n] = getattr(field.dt, n.lower()) if n != 'Week' else week
    mask = ~field.isna()
    df[prefix + 'Elapsed'] = np.where(mask,field.values.astype(np.int64) // 10 ** 9,None)
    if drop: df.drop(field_name, axis=1, inplace=True)
    return df

# Cell
def add_lag_features(df, field_name, prefix=None, lag_periods=[1]):
    "Helper function that adds lag features relevant to the column `field_name` of `df`."
    field = df[field_name]
    prefix = ifnone(prefix, field_name)
    for n in lag_periods: df[f'{prefix}-{n}p'] = df[field_name].shift(n)
    return df

# Cell
def add_lag_percentage_gain_features(df, field_name, prefix=None, lag_periods=[1]):
    "Helper function that adds lag percentage gain features relevant to the column `field_name` of `df`."
    field = df[field_name]
    prefix = ifnone(prefix, field_name)
    for n in lag_periods:
        df[f'{prefix}-{n}p_PG'] = df[field_name]/df[field_name].shift(n)
    return df

# Cell
def add_moving_average_features(df, field_name, prefix=None, windows=[3], weighted=True):
    "Helper function that adds moving average (rolling window) features relevant to the column `field_name` of `df`."
    field = df[field_name]
    prefix = ifnone(prefix, field_name)
    for n in windows:
        if weighted:
            weights = np.arange(1, n + 1)
            df[f'{prefix}_{n}p_MA'] = df[field_name].rolling(
                window=n).apply(lambda x: np.dot(x, weights) /
                                       weights.sum(), raw=True)
        else:
            df[f'{prefix}_{n}p_MA'] = df[field_name].rolling(window=n).mean()
    return df

# Cell
def add_moving_average_percentage_gain_features(df, field_name, prefix=None, windows=[3], weighted=True):
    "Helper function that adds moving average (rolling window) percentage gain features relevant to the column `field_name` of `df`."
    field = df[field_name]
    prefix = ifnone(prefix, field_name)
    for n in windows:
        if weighted:
            weights = np.arange(1, n + 1)
            df[f'{prefix}_{n}p_MA_PG'] = df[field_name]/df[field_name].rolling(
                window=n).apply(lambda x: np.dot(x, weights) /
                                       weights.sum(), raw=True)
        else:
            df[f'{prefix}_{n}p_MA_PG'] = df[field_name]/df[field_name].rolling(window=n).mean()
    return df

# Cell
def add_expanding_features(df, field_name, prefix=None, period=7):
    "Helper function that adds expanding features relevant to the column `field_name` of `df`."
    field = df[field_name]
    prefix = ifnone(prefix, field_name)
    df[f'{prefix}_{period}p_expanding'] = df[field_name].expanding(period).mean()
    return df

# Cell
def add_trend_features(df, field_name, prefix=None, windows=[3]):
    "Helper function that adds trend features relevant to the column `field_name` of `df`."
    field = df[field_name]
    prefix = ifnone(prefix, field_name)
    for n in windows:
        df[f'{prefix}_{n}p_trend'] = (df[field_name]
                .rolling(window=n)
                .mean()
                .diff()
                .fillna(0))
    return df