from typing import Any, Dict, Tuple


async def absent(hub, ctx, name: str, **kwargs) -> Tuple[bool, Dict[str, Any]]:
    status, result = await hub.exec.aws.ec2.internet_gateway.delete(
        ctx, name=name, **kwargs
    )
    if not status:
        return False, {"comment": result.get("exception", result)}

    return status, {"comment": f"Deleted ec2 internet_gateway: {name}"}


async def present(hub, ctx, name: str, **kwargs) -> Tuple[bool, Dict[str, Any]]:
    status, internet_gateway = await hub.exec.aws.ec2.internet_gateway.get(ctx, name)
    comments = []

    if not status:
        status, result = await hub.exec.aws.ec2.internet_gateway.create(
            ctx, name=name, **kwargs
        )

        if not status:
            return False, {"comment": result.get("exception", result)}
        comments.append(f"Created Ec2 internet_gateway: {name}")

    # TODO perform other updates as necessary

    return status, {"comment": "\n".join(comments)}
