"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlagEnum = exports.ReferenceTypeEnum = exports.EdgeDirectionEnum = exports.EdgeTypeEnum = exports.NodeTypeEnum = exports.MetadataTypeEnum = exports.CfnAttributesEnum = exports.ExtraneousFqnEnum = exports.AssetFqnEnum = exports.ConstructInfoFqnEnum = exports.CdkConstructIds = void 0;
/** Common cdk construct ids */
var CdkConstructIds;
(function (CdkConstructIds) {
    CdkConstructIds["DEFAULT"] = "Default";
    CdkConstructIds["RESOURCE"] = "Resource";
    CdkConstructIds["EXPORTS"] = "Exports";
})(CdkConstructIds = exports.CdkConstructIds || (exports.CdkConstructIds = {}));
/** Commonly used cdk construct info fqn (jsii fully-qualified ids) */
var ConstructInfoFqnEnum;
(function (ConstructInfoFqnEnum) {
    ConstructInfoFqnEnum["APP"] = "aws-cdk-lib.App";
    ConstructInfoFqnEnum["STAGE"] = "aws-cdk-lib.Stage";
    ConstructInfoFqnEnum["STACK"] = "aws-cdk-lib.Stack";
    ConstructInfoFqnEnum["NESTED_STACK"] = "aws-cdk-lib.NestedStack";
    ConstructInfoFqnEnum["CFN_STACK"] = "aws-cdk-lib.CfnStack";
    ConstructInfoFqnEnum["CFN_OUTPUT"] = "aws-cdk-lib.CfnOutput";
    ConstructInfoFqnEnum["CFN_PARAMETER"] = "aws-cdk-lib.CfnParameter";
    // Custom Resources
    ConstructInfoFqnEnum["CUSTOM_RESOURCE"] = "aws-cdk-lib.CustomResource";
    ConstructInfoFqnEnum["AWS_CUSTOM_RESOURCE"] = "aws-cdk-lib.custom_resources.AwsCustomResource";
    ConstructInfoFqnEnum["CUSTOM_RESOURCE_PROVIDER"] = "aws-cdk-lib.custom_resources.Provider";
    ConstructInfoFqnEnum["CUSTOM_RESOURCE_PROVIDER_2"] = "aws-cdk-lib.CustomResourceProvider";
    // Lambda
    ConstructInfoFqnEnum["LAMBDA"] = "aws-cdk-lib.aws_lambda.Function";
    ConstructInfoFqnEnum["CFN_LAMBDA"] = "aws-cdk-lib.aws_lambda.CfnFunction";
    ConstructInfoFqnEnum["LAMBDA_LAYER_VERSION"] = "aws-cdk-lib.aws_lambda.LayerVersion";
    ConstructInfoFqnEnum["CFN_LAMBDA_LAYER_VERSION"] = "aws-cdk-lib.aws_lambda.CfnLayerVersion";
    ConstructInfoFqnEnum["LAMBDA_ALIAS"] = "aws-cdk-lib.aws_lambda.Alias";
    ConstructInfoFqnEnum["CFN_LAMBDA_ALIAS"] = "aws-cdk-lib.aws_lambda.CfnAlias";
    ConstructInfoFqnEnum["LAMBDA_BASE"] = "aws-cdk-lib.aws_lambda.FunctionBase";
    // Assets
    ConstructInfoFqnEnum["ASSET_STAGING"] = "aws-cdk-lib.AssetStaging";
    ConstructInfoFqnEnum["S3_ASSET"] = "aws-cdk-lib.aws_s3_assets.Asset";
    ConstructInfoFqnEnum["ECR_TARBALL_ASSET"] = "aws-cdk-lib.aws_ecr_assets.TarballImageAsset";
    // EC2
    ConstructInfoFqnEnum["EC2_INSTANCE"] = "aws-cdk-lib.aws_ec2.Instance";
    ConstructInfoFqnEnum["CFN_EC2_INSTANCE"] = "aws-cdk-lib.aws_ec2.CfnInstance";
    ConstructInfoFqnEnum["SECURITY_GROUP"] = "aws-cdk-lib.aws_ec2.SecurityGroup";
    ConstructInfoFqnEnum["CFN_SECURITY_GROUP"] = "aws-cdk-lib.aws_ec2.CfnSecurityGroup";
    ConstructInfoFqnEnum["VPC"] = "aws-cdk-lib.aws_ec2.Vpc";
    ConstructInfoFqnEnum["CFN_VPC"] = "aws-cdk-lib.aws_ec2.CfnVpc";
    ConstructInfoFqnEnum["PRIVATE_SUBNET"] = "aws-cdk-lib.aws_ec2.PrivateSubnet";
    ConstructInfoFqnEnum["CFN_PRIVATE_SUBNET"] = "aws-cdk-lib.aws_ec2.CfnPrivateSubnet";
    ConstructInfoFqnEnum["PUBLIC_SUBNET"] = "aws-cdk-lib.aws_ec2.PublicSubnet";
    ConstructInfoFqnEnum["CFN_PUBLIC_SUBNET"] = "aws-cdk-lib.aws_ec2.CfnPublicSubnet";
})(ConstructInfoFqnEnum = exports.ConstructInfoFqnEnum || (exports.ConstructInfoFqnEnum = {}));
/** Fqns that denote a cdk asset */
exports.AssetFqnEnum = [
    ConstructInfoFqnEnum.S3_ASSET,
    ConstructInfoFqnEnum.ECR_TARBALL_ASSET,
];
/** Fqns considered extraneous */
exports.ExtraneousFqnEnum = [
    ...exports.AssetFqnEnum,
    ConstructInfoFqnEnum.ASSET_STAGING,
    ConstructInfoFqnEnum.LAMBDA_LAYER_VERSION,
    ConstructInfoFqnEnum.CFN_LAMBDA_LAYER_VERSION,
    ConstructInfoFqnEnum.LAMBDA_ALIAS,
    ConstructInfoFqnEnum.CFN_LAMBDA_ALIAS,
    ConstructInfoFqnEnum.LAMBDA_BASE,
];
/** Common cfn attribute keys */
var CfnAttributesEnum;
(function (CfnAttributesEnum) {
    CfnAttributesEnum["TYPE"] = "aws:cdk:cloudformation:type";
    CfnAttributesEnum["PROPS"] = "aws:cdk:cloudformation:props";
})(CfnAttributesEnum = exports.CfnAttributesEnum || (exports.CfnAttributesEnum = {}));
/** Common cdk metadata types */
var MetadataTypeEnum;
(function (MetadataTypeEnum) {
    MetadataTypeEnum["LOGICAL_ID"] = "aws:cdk:logicalId";
})(MetadataTypeEnum = exports.MetadataTypeEnum || (exports.MetadataTypeEnum = {}));
/** Node types handled by the graph */
var NodeTypeEnum;
(function (NodeTypeEnum) {
    /** Default node type - used for all nodes that don't have explicit type defined */
    NodeTypeEnum["DEFAULT"] = "DEFAULT";
    /** L1 cfn resource node */
    NodeTypeEnum["CFN_RESOURCE"] = "CFN_RESOURCE";
    /** L2 cdk resource node */
    NodeTypeEnum["RESOURCE"] = "RESOURCE";
    /** Cdk customer resource node */
    NodeTypeEnum["CUSTOM_RESOURCE"] = "CUSTOM_RESOURCE";
    /** Graph root node */
    NodeTypeEnum["ROOT"] = "ROOT";
    /** Cdk App node */
    NodeTypeEnum["APP"] = "APP";
    /** Cdk Stage node */
    NodeTypeEnum["STAGE"] = "STAGE";
    /** Cdk Stack node */
    NodeTypeEnum["STACK"] = "STACK";
    /** Cdk NestedStack node */
    NodeTypeEnum["NESTED_STACK"] = "NESTED_STACK";
    /** CfnOutput node */
    NodeTypeEnum["OUTPUT"] = "OUTPUT";
    /** CfnParameter node */
    NodeTypeEnum["PARAMETER"] = "PARAMETER";
    /** Cdk asset node */
    NodeTypeEnum["ASSET"] = "ASSET";
})(NodeTypeEnum = exports.NodeTypeEnum || (exports.NodeTypeEnum = {}));
/** Edge types handles by the graph */
var EdgeTypeEnum;
(function (EdgeTypeEnum) {
    /** Custom edge */
    EdgeTypeEnum["CUSTOM"] = "CUSTOM";
    /** Reference edge (Ref, Fn::GetAtt, Fn::ImportValue) */
    EdgeTypeEnum["REFERENCE"] = "REFERENCE";
    /** CloudFormation dependency edge */
    EdgeTypeEnum["DEPENDENCY"] = "DEPENDENCY";
})(EdgeTypeEnum = exports.EdgeTypeEnum || (exports.EdgeTypeEnum = {}));
/**
 * EdgeDirection specifies in which direction the edge is directed or if it is undirected.
 */
var EdgeDirectionEnum;
(function (EdgeDirectionEnum) {
    /** Indicates that edge is *undirected*; meaning there is no directional relationship between the **source** and **target**. */
    EdgeDirectionEnum["NONE"] = "none";
    /** Indicates the edge is *directed* from the **source** to the **target** */
    EdgeDirectionEnum["FORWARD"] = "forward";
    /** Indicates the edge is *directed* from the **target** to the **source** */
    EdgeDirectionEnum["BACK"] = "back";
    /** Indicates the edge is *bi-directional* */
    EdgeDirectionEnum["BOTH"] = "both";
})(EdgeDirectionEnum = exports.EdgeDirectionEnum || (exports.EdgeDirectionEnum = {}));
/** Reference edge types */
var ReferenceTypeEnum;
(function (ReferenceTypeEnum) {
    /** CloudFormation **Ref** reference */
    ReferenceTypeEnum["REF"] = "Ref";
    /** CloudFormation **Fn::GetAtt** reference */
    ReferenceTypeEnum["ATTRIBUTE"] = "Fn::GetAtt";
    /** CloudFormation **Fn::ImportValue** reference */
    ReferenceTypeEnum["IMPORT"] = "Fn::ImportValue";
})(ReferenceTypeEnum = exports.ReferenceTypeEnum || (exports.ReferenceTypeEnum = {}));
/** Graph flags */
var FlagEnum;
(function (FlagEnum) {
    /** Indicates that node is a cluster (container) and treated like an emphasized subgraph. */
    FlagEnum["CLUSTER"] = "CLUSTER";
    /** Indicates that node is non-resource container (Root, App) and used for structural purpose in the graph only. */
    FlagEnum["GRAPH_CONTAINER"] = "GRAPH_CONTAINER";
    /** Indicates that the entity is extraneous and considered collapsible to parent without impact of intent. */
    FlagEnum["EXTRANEOUS"] = "EXTRANEOUS";
    /** Indicates node is a simple CfnResource wrapper and can be collapsed without change of intent; Determined by only containing a single child of "Default" or "Resource" */
    FlagEnum["RESOURCE_WRAPPER"] = "RESOURCE_WRAPPER";
    /** Indicates node is considered a CDK Asset (Lambda Code, Docker Image, etc). */
    FlagEnum["ASSET"] = "ASSET";
    /** Indicates that node was created by CDK (`construct.node.defaultChild === CfnResource`). */
    FlagEnum["CDK_OWNED"] = "CDK_OWNED";
    /** Indicates that edge is closed; meaning `source === target`. This flag only gets applied on creation of edge, not during mutations to maintain initial intent. */
    FlagEnum["CLOSED_EDGE"] = "CLOSED_EDGE";
    /** Indicates that entity was mutated; meaning a mutation was performed to change originally computed graph value. */
    FlagEnum["MUTATED"] = "MUTATED";
    /** Indicates that cfn resource has equivalent cdk resource wrapper. (eg: Lambda => CfnLambda) */
    FlagEnum["WRAPPED_CFN_RESOURCE"] = "WRAPPED_CFN_RESOURCE";
})(FlagEnum = exports.FlagEnum || (exports.FlagEnum = {}));
//# sourceMappingURL=data:application/json;base64,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