"""
    Proxy Service

    This is the Insights Engine Proxy Service, the single touch point for accessing the insights engine services.   # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: eden.trainor@compassdigital.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from insights_engine.api_client import ApiClient, Endpoint as _Endpoint
from insights_engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from insights_engine.model.add_user_input import AddUserInput
from insights_engine.model.add_user_output import AddUserOutput
from insights_engine.model.get_user_output import GetUserOutput
from insights_engine.model.update_user_input import UpdateUserInput


class UserApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_user_endpoint = _Endpoint(
            settings={
                'response_type': (AddUserOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/user',
                'operation_id': 'add_user',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'add_user_input',
                ],
                'required': [
                    'app_name',
                    'user_name',
                    'add_user_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'add_user_input':
                        (AddUserInput,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'add_user_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_user_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/user',
                'operation_id': 'delete_user',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                ],
                'required': [
                    'app_name',
                    'user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_user_endpoint = _Endpoint(
            settings={
                'response_type': (GetUserOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/user',
                'operation_id': 'get_user',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                ],
                'required': [
                    'app_name',
                    'user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_user_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/user',
                'operation_id': 'update_user',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                    'update_user_input',
                ],
                'required': [
                    'app_name',
                    'user_name',
                    'update_user_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                    'update_user_input':
                        (UpdateUserInput,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                    'update_user_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def add_user(
        self,
        app_name,
        user_name,
        add_user_input,
        **kwargs
    ):
        """Registers a new user to your app  # noqa: E501

        Registers a new user to your app (app_name) and subscribes them to every generator registered with that app.  If this user has the same permissions as another user already registered on this app then they will share the same view, otherwise, a new view is made for them.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_user(app_name, user_name, add_user_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): The name of the app this method will be acting in
            user_name (str): Name of the user this method is acting on
            add_user_input (AddUserInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AddUserOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        kwargs['add_user_input'] = \
            add_user_input
        return self.add_user_endpoint.call_with_http_info(**kwargs)

    def delete_user(
        self,
        app_name,
        user_name,
        **kwargs
    ):
        """Delete this user from the app  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user(app_name, user_name, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): The name of the app this method will be acting in
            user_name (str): Name of the user this method is acting on

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        return self.delete_user_endpoint.call_with_http_info(**kwargs)

    def get_user(
        self,
        app_name,
        user_name,
        **kwargs
    ):
        """Gets subscriptions for registered users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user(app_name, user_name, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): The name of the app this method will be acting in
            user_name (str): Name of the user this method is acting on

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetUserOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        return self.get_user_endpoint.call_with_http_info(**kwargs)

    def update_user(
        self,
        app_name,
        user_name,
        update_user_input,
        **kwargs
    ):
        """update users permissions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user(app_name, user_name, update_user_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): The name of the app this method will be acting in
            user_name (str): Name of the user this method is acting on
            update_user_input (UpdateUserInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        kwargs['update_user_input'] = \
            update_user_input
        return self.update_user_endpoint.call_with_http_info(**kwargs)

