"""
    Proxy Service

    This is the Insights Engine Proxy Service, the single touch point for accessing the insights engine services.   # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: eden.trainor@compassdigital.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from insights_engine.api_client import ApiClient, Endpoint as _Endpoint
from insights_engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)


class MetricsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_all_user_metrics_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/metrics',
                'operation_id': 'get_all_user_metrics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                ],
                'required': [
                    'app_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                },
                'location_map': {
                    'app_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_user_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/metrics/user_name/{user_name}',
                'operation_id': 'get_user_metrics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                ],
                'required': [
                    'app_name',
                    'user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_all_user_metrics(
        self,
        app_name,
        **kwargs
    ):
        """Gets insight metrics for all registered users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_user_metrics(app_name, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): The name of the app this method will be acting in

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        return self.get_all_user_metrics_endpoint.call_with_http_info(**kwargs)

    def get_user_metrics(
        self,
        app_name,
        user_name,
        **kwargs
    ):
        """Gets insight metrics for a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_metrics(app_name, user_name, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): The name of the app this method will be acting in
            user_name (str): Name of the user this method is acting on

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        return self.get_user_metrics_endpoint.call_with_http_info(**kwargs)

