"""
    Proxy Service

    This is the Insights Engine Proxy Service, the single touch point for accessing the insights engine services.   # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: eden.trainor@compassdigital.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from insights_engine.api_client import ApiClient, Endpoint as _Endpoint
from insights_engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from insights_engine.model.get_group_insights_output import GetGroupInsightsOutput
from insights_engine.model.get_real_time_insights_input import GetRealTimeInsightsInput
from insights_engine.model.get_real_time_insights_output import GetRealTimeInsightsOutput
from insights_engine.model.get_user_insights_output import GetUserInsightsOutput


class InsightsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_group_insights_endpoint = _Endpoint(
            settings={
                'response_type': (GetGroupInsightsOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/get_group_insights',
                'operation_id': 'get_group_insights',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'group_name',
                    'admin_user_name',
                ],
                'required': [
                    'app_name',
                    'group_name',
                    'admin_user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'group_name':
                        (str,),
                    'admin_user_name':
                        (str,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'group_name': 'group_name',
                    'admin_user_name': 'admin_user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'group_name': 'query',
                    'admin_user_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_real_time_insights_endpoint = _Endpoint(
            settings={
                'response_type': (GetRealTimeInsightsOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/app/{app_name}/generator/{generator_name}',
                'operation_id': 'get_real_time_insights',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'generator_name',
                    'get_real_time_insights_input',
                ],
                'required': [
                    'app_name',
                    'generator_name',
                    'get_real_time_insights_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'generator_name':
                        (str,),
                    'get_real_time_insights_input':
                        (GetRealTimeInsightsInput,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'generator_name': 'generator_name',
                },
                'location_map': {
                    'app_name': 'path',
                    'generator_name': 'path',
                    'get_real_time_insights_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_user_insights_endpoint = _Endpoint(
            settings={
                'response_type': (GetUserInsightsOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/get_user_insights',
                'operation_id': 'get_user_insights',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                    'user_name',
                ],
                'required': [
                    'app_name',
                    'user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                    'user_name':
                        (str,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                    'user_name': 'user_name',
                },
                'location_map': {
                    'app_name': 'query',
                    'user_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.run_generators_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/run',
                'operation_id': 'run_generators',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_name',
                ],
                'required': [
                    'app_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_name':
                        (str,),
                },
                'attribute_map': {
                    'app_name': 'app_name',
                },
                'location_map': {
                    'app_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_group_insights(
        self,
        app_name,
        group_name,
        admin_user_name,
        **kwargs
    ):
        """Get unique insights payloads for this group  # noqa: E501

        Get unique insight payloads accross all users in this group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_insights(app_name, group_name, admin_user_name, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): The name of the app this method will be acting in
            group_name (str): The name of the admin's groups
            admin_user_name (str): The name of the admin this group action is effecting

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetGroupInsightsOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['group_name'] = \
            group_name
        kwargs['admin_user_name'] = \
            admin_user_name
        return self.get_group_insights_endpoint.call_with_http_info(**kwargs)

    def get_real_time_insights(
        self,
        app_name,
        generator_name,
        get_real_time_insights_input,
        **kwargs
    ):
        """Generate and return the results of an insight generator immediately  # noqa: E501

        Generate and return the results of an insight generator immediately  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_real_time_insights(app_name, generator_name, get_real_time_insights_input, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): The name of the app this method will be acting in
            generator_name (str): The name of the generator
            get_real_time_insights_input (GetRealTimeInsightsInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetRealTimeInsightsOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['generator_name'] = \
            generator_name
        kwargs['get_real_time_insights_input'] = \
            get_real_time_insights_input
        return self.get_real_time_insights_endpoint.call_with_http_info(**kwargs)

    def get_user_insights(
        self,
        app_name,
        user_name,
        **kwargs
    ):
        """Get insight payloads for this user  # noqa: E501

        Get fresh and saved payloads from this users subscribed insight generator windows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_insights(app_name, user_name, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): The name of the app this method will be acting in
            user_name (str): Name of the user this method is acting on

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetUserInsightsOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        kwargs['user_name'] = \
            user_name
        return self.get_user_insights_endpoint.call_with_http_info(**kwargs)

    def run_generators(
        self,
        app_name,
        **kwargs
    ):
        """Refresh insights for app  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_generators(app_name, async_req=True)
        >>> result = thread.get()

        Args:
            app_name (str): The name of the app this method will be acting in

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['app_name'] = \
            app_name
        return self.run_generators_endpoint.call_with_http_info(**kwargs)

