"""
    Proxy Service

    This is the Insights Engine Proxy Service, the single touch point for accessing the insights engine services.   # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: eden.trainor@compassdigital.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from insights_engine.api_client import ApiClient, Endpoint as _Endpoint
from insights_engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from insights_engine.model.add_members_input import AddMembersInput
from insights_engine.model.add_members_output import AddMembersOutput
from insights_engine.model.create_group_input import CreateGroupInput
from insights_engine.model.create_group_output import CreateGroupOutput
from insights_engine.model.delete_group_members_input import DeleteGroupMembersInput
from insights_engine.model.get_all_admin_groups_output import GetAllAdminGroupsOutput
from insights_engine.model.get_group_admins_output import GetGroupAdminsOutput
from insights_engine.model.get_group_members_ouput import GetGroupMembersOuput


class GroupsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_members_endpoint = _Endpoint(
            settings={
                'response_type': (AddMembersOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/group/{group_name}/member',
                'operation_id': 'add_members',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'admin_user_name',
                    'app_name',
                    'group_name',
                    'add_members_input',
                ],
                'required': [
                    'admin_user_name',
                    'app_name',
                    'group_name',
                    'add_members_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'admin_user_name':
                        (str,),
                    'app_name':
                        (str,),
                    'group_name':
                        (str,),
                    'add_members_input':
                        (AddMembersInput,),
                },
                'attribute_map': {
                    'admin_user_name': 'admin_user_name',
                    'app_name': 'app_name',
                    'group_name': 'group_name',
                },
                'location_map': {
                    'admin_user_name': 'query',
                    'app_name': 'query',
                    'group_name': 'path',
                    'add_members_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_group_endpoint = _Endpoint(
            settings={
                'response_type': (CreateGroupOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/group',
                'operation_id': 'create_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'admin_user_name',
                    'app_name',
                    'create_group_input',
                ],
                'required': [
                    'admin_user_name',
                    'app_name',
                    'create_group_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'admin_user_name':
                        (str,),
                    'app_name':
                        (str,),
                    'create_group_input':
                        (CreateGroupInput,),
                },
                'attribute_map': {
                    'admin_user_name': 'admin_user_name',
                    'app_name': 'app_name',
                },
                'location_map': {
                    'admin_user_name': 'query',
                    'app_name': 'query',
                    'create_group_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_all_admin_groups_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/group',
                'operation_id': 'delete_all_admin_groups',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'admin_user_name',
                    'app_name',
                ],
                'required': [
                    'admin_user_name',
                    'app_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'admin_user_name':
                        (str,),
                    'app_name':
                        (str,),
                },
                'attribute_map': {
                    'admin_user_name': 'admin_user_name',
                    'app_name': 'app_name',
                },
                'location_map': {
                    'admin_user_name': 'query',
                    'app_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_group_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/group/{group_name}',
                'operation_id': 'delete_group',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'admin_user_name',
                    'app_name',
                    'group_name',
                ],
                'required': [
                    'admin_user_name',
                    'app_name',
                    'group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'admin_user_name':
                        (str,),
                    'app_name':
                        (str,),
                    'group_name':
                        (str,),
                },
                'attribute_map': {
                    'admin_user_name': 'admin_user_name',
                    'app_name': 'app_name',
                    'group_name': 'group_name',
                },
                'location_map': {
                    'admin_user_name': 'query',
                    'app_name': 'query',
                    'group_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_group_members_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/group/{group_name}/member',
                'operation_id': 'delete_group_members',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'admin_user_name',
                    'app_name',
                    'group_name',
                    'delete_group_members_input',
                ],
                'required': [
                    'admin_user_name',
                    'app_name',
                    'group_name',
                    'delete_group_members_input',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'admin_user_name':
                        (str,),
                    'app_name':
                        (str,),
                    'group_name':
                        (str,),
                    'delete_group_members_input':
                        (DeleteGroupMembersInput,),
                },
                'attribute_map': {
                    'admin_user_name': 'admin_user_name',
                    'app_name': 'app_name',
                    'group_name': 'group_name',
                },
                'location_map': {
                    'admin_user_name': 'query',
                    'app_name': 'query',
                    'group_name': 'path',
                    'delete_group_members_input': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_all_admin_groups_endpoint = _Endpoint(
            settings={
                'response_type': (GetAllAdminGroupsOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/group',
                'operation_id': 'get_all_admin_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'admin_user_name',
                    'app_name',
                ],
                'required': [
                    'admin_user_name',
                    'app_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'admin_user_name':
                        (str,),
                    'app_name':
                        (str,),
                },
                'attribute_map': {
                    'admin_user_name': 'admin_user_name',
                    'app_name': 'app_name',
                },
                'location_map': {
                    'admin_user_name': 'query',
                    'app_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_group_admins_endpoint = _Endpoint(
            settings={
                'response_type': (GetGroupAdminsOutput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/group/{group_name}',
                'operation_id': 'get_group_admins',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'admin_user_name',
                    'app_name',
                    'group_name',
                ],
                'required': [
                    'admin_user_name',
                    'app_name',
                    'group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'admin_user_name':
                        (str,),
                    'app_name':
                        (str,),
                    'group_name':
                        (str,),
                },
                'attribute_map': {
                    'admin_user_name': 'admin_user_name',
                    'app_name': 'app_name',
                    'group_name': 'group_name',
                },
                'location_map': {
                    'admin_user_name': 'query',
                    'app_name': 'query',
                    'group_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_group_members_endpoint = _Endpoint(
            settings={
                'response_type': (GetGroupMembersOuput,),
                'auth': [
                    'Authorization'
                ],
                'endpoint_path': '/group/{group_name}/member',
                'operation_id': 'get_group_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'admin_user_name',
                    'app_name',
                    'group_name',
                ],
                'required': [
                    'admin_user_name',
                    'app_name',
                    'group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'admin_user_name':
                        (str,),
                    'app_name':
                        (str,),
                    'group_name':
                        (str,),
                },
                'attribute_map': {
                    'admin_user_name': 'admin_user_name',
                    'app_name': 'app_name',
                    'group_name': 'group_name',
                },
                'location_map': {
                    'admin_user_name': 'query',
                    'app_name': 'query',
                    'group_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/plain'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def add_members(
        self,
        admin_user_name,
        app_name,
        group_name,
        add_members_input,
        **kwargs
    ):
        """Add members to group  # noqa: E501

        Adds a set of registered users/members to a group that already exists  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_members(admin_user_name, app_name, group_name, add_members_input, async_req=True)
        >>> result = thread.get()

        Args:
            admin_user_name (str): The name of the admin this group action is effecting
            app_name (str): The name of the app this method will be acting in
            group_name (str): The name of the admin's groups
            add_members_input (AddMembersInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AddMembersOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['admin_user_name'] = \
            admin_user_name
        kwargs['app_name'] = \
            app_name
        kwargs['group_name'] = \
            group_name
        kwargs['add_members_input'] = \
            add_members_input
        return self.add_members_endpoint.call_with_http_info(**kwargs)

    def create_group(
        self,
        admin_user_name,
        app_name,
        create_group_input,
        **kwargs
    ):
        """Create Admin Group  # noqa: E501

        Create a new group for this admin only. \\\"members\\\" can be optionally supplied in the body to create an empty or filled group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_group(admin_user_name, app_name, create_group_input, async_req=True)
        >>> result = thread.get()

        Args:
            admin_user_name (str): The name of the admin this group action is effecting
            app_name (str): The name of the app this method will be acting in
            create_group_input (CreateGroupInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateGroupOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['admin_user_name'] = \
            admin_user_name
        kwargs['app_name'] = \
            app_name
        kwargs['create_group_input'] = \
            create_group_input
        return self.create_group_endpoint.call_with_http_info(**kwargs)

    def delete_all_admin_groups(
        self,
        admin_user_name,
        app_name,
        **kwargs
    ):
        """Delete Admin's Groups  # noqa: E501

        Delete all the groups for this admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_all_admin_groups(admin_user_name, app_name, async_req=True)
        >>> result = thread.get()

        Args:
            admin_user_name (str): The name of the admin this group action is effecting
            app_name (str): The name of the app this method will be acting in

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['admin_user_name'] = \
            admin_user_name
        kwargs['app_name'] = \
            app_name
        return self.delete_all_admin_groups_endpoint.call_with_http_info(**kwargs)

    def delete_group(
        self,
        admin_user_name,
        app_name,
        group_name,
        **kwargs
    ):
        """Delete a group  # noqa: E501

        Completely delete the group, group_name, belonging to this admin_user_name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_group(admin_user_name, app_name, group_name, async_req=True)
        >>> result = thread.get()

        Args:
            admin_user_name (str): The name of the admin this group action is effecting
            app_name (str): The name of the app this method will be acting in
            group_name (str): The name of the admin's groups

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['admin_user_name'] = \
            admin_user_name
        kwargs['app_name'] = \
            app_name
        kwargs['group_name'] = \
            group_name
        return self.delete_group_endpoint.call_with_http_info(**kwargs)

    def delete_group_members(
        self,
        admin_user_name,
        app_name,
        group_name,
        delete_group_members_input,
        **kwargs
    ):
        """Delete Group members  # noqa: E501

        Removes the provided set of members from the group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_group_members(admin_user_name, app_name, group_name, delete_group_members_input, async_req=True)
        >>> result = thread.get()

        Args:
            admin_user_name (str): The name of the admin this group action is effecting
            app_name (str): The name of the app this method will be acting in
            group_name (str): The name of the admin's groups
            delete_group_members_input (DeleteGroupMembersInput):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['admin_user_name'] = \
            admin_user_name
        kwargs['app_name'] = \
            app_name
        kwargs['group_name'] = \
            group_name
        kwargs['delete_group_members_input'] = \
            delete_group_members_input
        return self.delete_group_members_endpoint.call_with_http_info(**kwargs)

    def get_all_admin_groups(
        self,
        admin_user_name,
        app_name,
        **kwargs
    ):
        """Fetch Admins Groups  # noqa: E501

        Gets all the groups belonging to the specified admin user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_admin_groups(admin_user_name, app_name, async_req=True)
        >>> result = thread.get()

        Args:
            admin_user_name (str): The name of the admin this group action is effecting
            app_name (str): The name of the app this method will be acting in

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetAllAdminGroupsOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['admin_user_name'] = \
            admin_user_name
        kwargs['app_name'] = \
            app_name
        return self.get_all_admin_groups_endpoint.call_with_http_info(**kwargs)

    def get_group_admins(
        self,
        admin_user_name,
        app_name,
        group_name,
        **kwargs
    ):
        """Fetch admins for group name  # noqa: E501

        Gets all the admins that have a group with this group name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_admins(admin_user_name, app_name, group_name, async_req=True)
        >>> result = thread.get()

        Args:
            admin_user_name (str): The name of the admin this group action is effecting
            app_name (str): The name of the app this method will be acting in
            group_name (str): The name of the admin's groups

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetGroupAdminsOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['admin_user_name'] = \
            admin_user_name
        kwargs['app_name'] = \
            app_name
        kwargs['group_name'] = \
            group_name
        return self.get_group_admins_endpoint.call_with_http_info(**kwargs)

    def get_group_members(
        self,
        admin_user_name,
        app_name,
        group_name,
        **kwargs
    ):
        """Fetch group members  # noqa: E501

        Fetch all the members of that group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_members(admin_user_name, app_name, group_name, async_req=True)
        >>> result = thread.get()

        Args:
            admin_user_name (str): The name of the admin this group action is effecting
            app_name (str): The name of the app this method will be acting in
            group_name (str): The name of the admin's groups

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetGroupMembersOuput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['admin_user_name'] = \
            admin_user_name
        kwargs['app_name'] = \
            app_name
        kwargs['group_name'] = \
            group_name
        return self.get_group_members_endpoint.call_with_http_info(**kwargs)

