"""
Copyright 2018 Goldman Sachs.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
"""
import copy
import inspect
import pickle
import sys

from gs_quant.base import Base
from gs_quant.common import Currency


def classes(module_name) -> list:
    module_path = 'gs_quant.target.' + module_name
    __import__(module_path)
    module = sys.modules[module_path]
    return [m for n, m in inspect.getmembers(module) if inspect.isclass(m) and issubclass(m, Base) and m is not Base]


def test_enum():
    ccy = copy.deepcopy(Currency.HUF)
    assert ccy == Currency.HUF

    gbp_pickled = pickle.dumps(Currency.GBP)
    assert pickle.loads(gbp_pickled) == Currency.GBP


def test_classes():
    for module_name in ('assets', 'backtests', 'charts', 'common', 'content', 'coordinates', 'countries', 'data',
                        'hedge', 'indices', 'instrument', 'monitor', 'portfolios', 'reports', 'risk', 'trades',
                        'workspaces_markets'):
        for typ in classes(module_name):
            fields_by_name = typ._fields_by_name()
            if not fields_by_name:
                continue

            obj = typ.default_instance()

            for fld in fields_by_name.values():
                _ = object.__getattribute__(obj, fld.name)
                if fld.init:
                    setattr(obj, fld.name, None)
