/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <yarp/dev/Map2DLocationData.h>

namespace yarp {
namespace dev {

// Default constructor
Map2DLocationData::Map2DLocationData() :
        WirePortable(),
        map_id(""),
        x(0),
        y(0),
        theta(0),
        description("")
{
}

// Constructor with field values
Map2DLocationData::Map2DLocationData(const std::string& map_id,
                                     const double x,
                                     const double y,
                                     const double theta,
                                     const std::string& description) :
        WirePortable(),
        map_id(map_id),
        x(x),
        y(y),
        theta(theta),
        description(description)
{
}

// Read structure on a Wire
bool Map2DLocationData::read(yarp::os::idl::WireReader& reader)
{
    if (!read_map_id(reader)) {
        return false;
    }
    if (!read_x(reader)) {
        return false;
    }
    if (!read_y(reader)) {
        return false;
    }
    if (!read_theta(reader)) {
        return false;
    }
    if (!read_description(reader)) {
        return false;
    }
    return !reader.isError();
}

// Read structure on a Connection
bool Map2DLocationData::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader(5)) {
        return false;
    }
    return read(reader);
}

// Write structure on a Wire
bool Map2DLocationData::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!write_map_id(writer)) {
        return false;
    }
    if (!write_x(writer)) {
        return false;
    }
    if (!write_y(writer)) {
        return false;
    }
    if (!write_theta(writer)) {
        return false;
    }
    if (!write_description(writer)) {
        return false;
    }
    return !writer.isError();
}

// Write structure on a Connection
bool Map2DLocationData::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(5)) {
        return false;
    }
    return write(writer);
}

// Convert to a printable string
std::string Map2DLocationData::toString() const
{
    yarp::os::Bottle b;
    b.read(*this);
    return b.toString();
}

// Editor: default constructor
Map2DLocationData::Editor::Editor()
{
    group = 0;
    obj_owned = true;
    obj = new Map2DLocationData;
    dirty_flags(false);
    yarp().setOwner(*this);
}

// Editor: constructor with base class
Map2DLocationData::Editor::Editor(Map2DLocationData& obj)
{
    group = 0;
    obj_owned = false;
    edit(obj, false);
    yarp().setOwner(*this);
}

// Editor: destructor
Map2DLocationData::Editor::~Editor()
{
    if (obj_owned) {
        delete obj;
    }
}

// Editor: edit
bool Map2DLocationData::Editor::edit(Map2DLocationData& obj, bool dirty)
{
    if (obj_owned) {
        delete this->obj;
    }
    this->obj = &obj;
    obj_owned = false;
    dirty_flags(dirty);
    return true;
}

// Editor: validity check
bool Map2DLocationData::Editor::isValid() const
{
    return obj != nullptr;
}

// Editor: state
Map2DLocationData& Map2DLocationData::Editor::state()
{
    return *obj;
}

// Editor: grouping begin
void Map2DLocationData::Editor::start_editing()
{
    group++;
}

// Editor: grouping end
void Map2DLocationData::Editor::stop_editing()
{
    group--;
    if (group == 0 && is_dirty) {
        communicate();
    }
}
// Editor: map_id setter
void Map2DLocationData::Editor::set_map_id(const std::string& map_id)
{
    will_set_map_id();
    obj->map_id = map_id;
    mark_dirty_map_id();
    communicate();
    did_set_map_id();
}

// Editor: map_id getter
const std::string& Map2DLocationData::Editor::get_map_id() const
{
    return obj->map_id;
}

// Editor: map_id will_set
bool Map2DLocationData::Editor::will_set_map_id()
{
    return true;
}

// Editor: map_id did_set
bool Map2DLocationData::Editor::did_set_map_id()
{
    return true;
}

// Editor: x setter
void Map2DLocationData::Editor::set_x(const double x)
{
    will_set_x();
    obj->x = x;
    mark_dirty_x();
    communicate();
    did_set_x();
}

// Editor: x getter
double Map2DLocationData::Editor::get_x() const
{
    return obj->x;
}

// Editor: x will_set
bool Map2DLocationData::Editor::will_set_x()
{
    return true;
}

// Editor: x did_set
bool Map2DLocationData::Editor::did_set_x()
{
    return true;
}

// Editor: y setter
void Map2DLocationData::Editor::set_y(const double y)
{
    will_set_y();
    obj->y = y;
    mark_dirty_y();
    communicate();
    did_set_y();
}

// Editor: y getter
double Map2DLocationData::Editor::get_y() const
{
    return obj->y;
}

// Editor: y will_set
bool Map2DLocationData::Editor::will_set_y()
{
    return true;
}

// Editor: y did_set
bool Map2DLocationData::Editor::did_set_y()
{
    return true;
}

// Editor: theta setter
void Map2DLocationData::Editor::set_theta(const double theta)
{
    will_set_theta();
    obj->theta = theta;
    mark_dirty_theta();
    communicate();
    did_set_theta();
}

// Editor: theta getter
double Map2DLocationData::Editor::get_theta() const
{
    return obj->theta;
}

// Editor: theta will_set
bool Map2DLocationData::Editor::will_set_theta()
{
    return true;
}

// Editor: theta did_set
bool Map2DLocationData::Editor::did_set_theta()
{
    return true;
}

// Editor: description setter
void Map2DLocationData::Editor::set_description(const std::string& description)
{
    will_set_description();
    obj->description = description;
    mark_dirty_description();
    communicate();
    did_set_description();
}

// Editor: description getter
const std::string& Map2DLocationData::Editor::get_description() const
{
    return obj->description;
}

// Editor: description will_set
bool Map2DLocationData::Editor::will_set_description()
{
    return true;
}

// Editor: description did_set
bool Map2DLocationData::Editor::did_set_description()
{
    return true;
}

// Editor: clean
void Map2DLocationData::Editor::clean()
{
    dirty_flags(false);
}

// Editor: read
bool Map2DLocationData::Editor::read(yarp::os::ConnectionReader& connection)
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        return false;
    }
    int len = reader.getLength();
    if (len == 0) {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(1)) {
            return false;
        }
        writer.writeString("send: 'help' or 'patch (param1 val1) (param2 val2)'");
        return true;
    }
    std::string tag;
    if (!reader.readString(tag)) {
        return false;
    }
    if (tag == "help") {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(2)) {
            return false;
        }
        if (!writer.writeTag("many", 1, 0)) {
            return false;
        }
        if (reader.getLength() > 0) {
            std::string field;
            if (!reader.readString(field)) {
                return false;
            }
            if (field == "map_id") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("std::string map_id")) {
                    return false;
                }
                if (!writer.writeString("name of the map")) {
                    return false;
                }
            }
            if (field == "x") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double x")) {
                    return false;
                }
                if (!writer.writeString("x position of the location [m], expressed in the map reference frame")) {
                    return false;
                }
            }
            if (field == "y") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double y")) {
                    return false;
                }
                if (!writer.writeString("y position of the location [m], expressed in the map reference frame")) {
                    return false;
                }
            }
            if (field == "theta") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double theta")) {
                    return false;
                }
                if (!writer.writeString("orientation [deg] in the map reference frame")) {
                    return false;
                }
            }
            if (field == "description") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("std::string description")) {
                    return false;
                }
                if (!writer.writeString("user defined string")) {
                    return false;
                }
            }
        }
        if (!writer.writeListHeader(6)) {
            return false;
        }
        writer.writeString("*** Available fields:");
        writer.writeString("map_id");
        writer.writeString("x");
        writer.writeString("y");
        writer.writeString("theta");
        writer.writeString("description");
        return true;
    }
    bool nested = true;
    bool have_act = false;
    if (tag != "patch") {
        if (((len - 1) % 2) != 0) {
            return false;
        }
        len = 1 + ((len - 1) / 2);
        nested = false;
        have_act = true;
    }
    for (int i = 1; i < len; ++i) {
        if (nested && !reader.readListHeader(3)) {
            return false;
        }
        std::string act;
        std::string key;
        if (have_act) {
            act = tag;
        } else if (!reader.readString(act)) {
            return false;
        }
        if (!reader.readString(key)) {
            return false;
        }
        if (key == "map_id") {
            will_set_map_id();
            if (!obj->nested_read_map_id(reader)) {
                return false;
            }
            did_set_map_id();
        } else if (key == "x") {
            will_set_x();
            if (!obj->nested_read_x(reader)) {
                return false;
            }
            did_set_x();
        } else if (key == "y") {
            will_set_y();
            if (!obj->nested_read_y(reader)) {
                return false;
            }
            did_set_y();
        } else if (key == "theta") {
            will_set_theta();
            if (!obj->nested_read_theta(reader)) {
                return false;
            }
            did_set_theta();
        } else if (key == "description") {
            will_set_description();
            if (!obj->nested_read_description(reader)) {
                return false;
            }
            did_set_description();
        } else {
            // would be useful to have a fallback here
        }
    }
    reader.accept();
    yarp::os::idl::WireWriter writer(reader);
    if (writer.isNull()) {
        return true;
    }
    writer.writeListHeader(1);
    writer.writeVocab32('o', 'k');
    return true;
}

// Editor: write
bool Map2DLocationData::Editor::write(yarp::os::ConnectionWriter& connection) const
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(dirty_count + 1)) {
        return false;
    }
    if (!writer.writeString("patch")) {
        return false;
    }
    if (is_dirty_map_id) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("map_id")) {
            return false;
        }
        if (!obj->nested_write_map_id(writer)) {
            return false;
        }
    }
    if (is_dirty_x) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("x")) {
            return false;
        }
        if (!obj->nested_write_x(writer)) {
            return false;
        }
    }
    if (is_dirty_y) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("y")) {
            return false;
        }
        if (!obj->nested_write_y(writer)) {
            return false;
        }
    }
    if (is_dirty_theta) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("theta")) {
            return false;
        }
        if (!obj->nested_write_theta(writer)) {
            return false;
        }
    }
    if (is_dirty_description) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("description")) {
            return false;
        }
        if (!obj->nested_write_description(writer)) {
            return false;
        }
    }
    return !writer.isError();
}

// Editor: send if possible
void Map2DLocationData::Editor::communicate()
{
    if (group != 0) {
        return;
    }
    if (yarp().canWrite()) {
        yarp().write(*this);
        clean();
    }
}

// Editor: mark dirty overall
void Map2DLocationData::Editor::mark_dirty()
{
    is_dirty = true;
}

// Editor: map_id mark_dirty
void Map2DLocationData::Editor::mark_dirty_map_id()
{
    if (is_dirty_map_id) {
        return;
    }
    dirty_count++;
    is_dirty_map_id = true;
    mark_dirty();
}

// Editor: x mark_dirty
void Map2DLocationData::Editor::mark_dirty_x()
{
    if (is_dirty_x) {
        return;
    }
    dirty_count++;
    is_dirty_x = true;
    mark_dirty();
}

// Editor: y mark_dirty
void Map2DLocationData::Editor::mark_dirty_y()
{
    if (is_dirty_y) {
        return;
    }
    dirty_count++;
    is_dirty_y = true;
    mark_dirty();
}

// Editor: theta mark_dirty
void Map2DLocationData::Editor::mark_dirty_theta()
{
    if (is_dirty_theta) {
        return;
    }
    dirty_count++;
    is_dirty_theta = true;
    mark_dirty();
}

// Editor: description mark_dirty
void Map2DLocationData::Editor::mark_dirty_description()
{
    if (is_dirty_description) {
        return;
    }
    dirty_count++;
    is_dirty_description = true;
    mark_dirty();
}

// Editor: dirty_flags
void Map2DLocationData::Editor::dirty_flags(bool flag)
{
    is_dirty = flag;
    is_dirty_map_id = flag;
    is_dirty_x = flag;
    is_dirty_y = flag;
    is_dirty_theta = flag;
    is_dirty_description = flag;
    dirty_count = flag ? 5 : 0;
}

// read map_id field
bool Map2DLocationData::read_map_id(yarp::os::idl::WireReader& reader)
{
    if (!reader.readString(map_id)) {
        reader.fail();
        return false;
    }
    return true;
}

// write map_id field
bool Map2DLocationData::write_map_id(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeString(map_id)) {
        return false;
    }
    return true;
}

// read (nested) map_id field
bool Map2DLocationData::nested_read_map_id(yarp::os::idl::WireReader& reader)
{
    if (!reader.readString(map_id)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) map_id field
bool Map2DLocationData::nested_write_map_id(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeString(map_id)) {
        return false;
    }
    return true;
}

// read x field
bool Map2DLocationData::read_x(yarp::os::idl::WireReader& reader)
{
    if (!reader.readFloat64(x)) {
        reader.fail();
        return false;
    }
    return true;
}

// write x field
bool Map2DLocationData::write_x(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(x)) {
        return false;
    }
    return true;
}

// read (nested) x field
bool Map2DLocationData::nested_read_x(yarp::os::idl::WireReader& reader)
{
    if (!reader.readFloat64(x)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) x field
bool Map2DLocationData::nested_write_x(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(x)) {
        return false;
    }
    return true;
}

// read y field
bool Map2DLocationData::read_y(yarp::os::idl::WireReader& reader)
{
    if (!reader.readFloat64(y)) {
        reader.fail();
        return false;
    }
    return true;
}

// write y field
bool Map2DLocationData::write_y(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(y)) {
        return false;
    }
    return true;
}

// read (nested) y field
bool Map2DLocationData::nested_read_y(yarp::os::idl::WireReader& reader)
{
    if (!reader.readFloat64(y)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) y field
bool Map2DLocationData::nested_write_y(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(y)) {
        return false;
    }
    return true;
}

// read theta field
bool Map2DLocationData::read_theta(yarp::os::idl::WireReader& reader)
{
    if (!reader.readFloat64(theta)) {
        reader.fail();
        return false;
    }
    return true;
}

// write theta field
bool Map2DLocationData::write_theta(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(theta)) {
        return false;
    }
    return true;
}

// read (nested) theta field
bool Map2DLocationData::nested_read_theta(yarp::os::idl::WireReader& reader)
{
    if (!reader.readFloat64(theta)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) theta field
bool Map2DLocationData::nested_write_theta(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(theta)) {
        return false;
    }
    return true;
}

// read description field
bool Map2DLocationData::read_description(yarp::os::idl::WireReader& reader)
{
    if (!reader.readString(description)) {
        reader.fail();
        return false;
    }
    return true;
}

// write description field
bool Map2DLocationData::write_description(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeString(description)) {
        return false;
    }
    return true;
}

// read (nested) description field
bool Map2DLocationData::nested_read_description(yarp::os::idl::WireReader& reader)
{
    if (!reader.readString(description)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) description field
bool Map2DLocationData::nested_write_description(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeString(description)) {
        return false;
    }
    return true;
}

} // namespace yarp
} // namespace dev
