# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/33_files.ipynb (unless otherwise specified).

__all__ = ['get_files', 'file_detail']

from typing import Union, List
from .imports import Path, pd


def get_files(
    path: Path,
    skip: Union[str, List[str]] = None
) -> pd.DataFrame:
    """Get all file paths from a directory"""
    path = Path(path).absolute()
    files = []
    if type(skip) == str:
        def not_skipping(phrase) -> bool:
            return skip in phrase
    elif type(skip) == list:
        def not_skipping(phrase) -> bool:
            for sk in skip:
                if sk in phrase:
                    return True
            return False
    elif skip is None:
        def not_skipping(x): return True
    else:
        raise TypeError(
            f"type of skip not correct: {type(skip)}")

    def get_files_(p: Path) -> None:
        if p.is_dir():
            for i in p.ls():
                if not_skipping(i):
                    get_files_(p/i)
        else:
            files.append(str(p))
    get_files_(path)

    return pd.DataFrame(dict(path=files))


def file_detail(
    path: Path,
    skip: Union[str, List[str]] = None
) -> pd.DataFrame:
    """
    Get detailed file information from a directory
    """
    file_df = get_files(path, skip=skip)

    def find_type(x):
        try:
            x = Path(x)
            if x.is_dir():
                return "directory"
            file_type = x.name.split(".")[-1]
            if file_type == x.name:
                return None
            else:
                return file_type
        except Exception as e:
            return None

    def find_parent(x):
        try:
            x = Path(x)
            return x.parent.name
        except Exception as e:
            return None

    def find_depth(x):
        try:
            x = Path(x)
            return len(x.parts)
        except Exception as e:
            return None
    file_df["file_type"] = file_df.path.apply(find_type)
    file_df["parent"] = file_df.path.apply(find_parent)
    file_df["depth"] = file_df.path.apply(find_depth)

    return file_df
