import { Component, OnInit, Inject } from "@angular/core";
import { MatDialogRef, MAT_DIALOG_DATA } from "@angular/material/dialog";

@Component({
  selector: "app-confirmation-dialog",
  templateUrl: "./confirmation-dialog.component.html",
  styleUrls: ["./confirmation-dialog.component.scss"]
})
export class ConfirmationDialogComponent implements OnInit {
  public customMessage: string;

  constructor(
    private dialogRef: MatDialogRef<ConfirmationDialogComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any
) {}

  ngOnInit(): void {
    if (this.data) {
      this.customMessage = this.data.message;
    }
  }

  public onConfirm(confirmed: boolean): void {
    this.dialogRef.close(confirmed);
  }

  public onNoClick() {
    this.dialogRef.close(false);
  }
}
