# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['opsrampcli']

package_data = \
{'': ['*']}

install_requires = \
['DateTime>=4.4,<5.0',
 'PyYAML>=6.0,<7.0',
 'XlsxWriter>=3.0.3,<4.0.0',
 'json5>=0.9.8,<0.10.0',
 'openpyxl>=3.0.10,<4.0.0',
 'pandas>=1.3.0,<2.0.0',
 'requests>=2.28.0,<3.0.0']

entry_points = \
{'console_scripts': ['opcli = opsrampcli.opsrampcli:main']}

setup_kwargs = {
    'name': 'opsrampcli',
    'version': '0.9.0',
    'description': 'A command line interface for OpsRamp',
    'long_description': '# OpsRamp Command Line Interface\n\nThis is a utility script that allows easy searching and manipulation of various OpsRamp items and configurations.  You can specify connection credentials via command line, or you can [set up an environments file](#credentials) to contain the credentials you need to use, which makes it easier if you need to manage multiple credentials.\n\n\n# <a id="Available"></a>Available Commands\nThe available commands are:\n\n\n| opcli Command                               | Description                                                                                                               |\n|---------------------------------------------|---------------------------------------------------------------------------------------------------------------------------|\n| [getalerts](#getalerts)                     | Search for and take action on alerts                                                                                      |\n| [postalerts](#postalerts)                   | Post alerts using the API (using OAuth creds)                                                                             |\n| [webhookalerts](#webhookalerts)             | Post alerts to a Webhook integration                                                                                      |\n| [getincidents](#getincidents)               | Search and take action on Incidents                                                                                       |\n| [getresources](#getresources)               | Search for and take action on resources/devices                                                                           |\n| [exportservicemaps](#exportservicemaps)     | Export one or more full Service Map definitions to a file which can be manipulated and re-imported                        |\n| [importservicemaps](#importservicemaps)     | Import (and optionally transform while doing so) from a Service Map export file                                           |\n| [cloneservicemaps](#cloneservicemaps)       | Copy an existing Service Map, with transformations/replacements (useful when you have a template Service Map to re-use)   |\n| [transformsvcmap](#transformsvcmap)         | Apply regex replacements to an exported Service Map and create a new transformed export file with the changes             |\n| [getservicemaps](#getservicemaps)           | Get Service Map definitions                                                                                               |\n| [getchildsvcgroups](#getchildsvcgroups)     | Get child Service Groups of a parent Service                                                                              |\n| [getservicegroup](#getservicegroup)         | Get the full definition of a Service Group                                                                                |\n| [exportcustattrfile](#exportcustattrfile)   | Generate an Excel or csv file from existing custom attribute values                                                       |\n| [importcustattrfile](#importcustattrfile)   | Import an Excel file containing custom attribute values                                                                   |\n| [getcustomattrs](#getcustomattrs)           | Get custom attribute definitions                                                                                          |\n| [getdiscoprofile](#getdiscoprofile)         | Get discovery profile definition                                                                                          |\n| [getalertesc](#getalertesc)                 | Search and get Escalation Policy definitions                                                                              |\n| [migratealertesc](#migratealertesc)         | Migrate/copy Escalation Policies within same tenant or from one tenant to another                                         |\n| [clonetemplates](#clonetemplates)           | Clone monitoring templates                                                                                                |\n\n&nbsp;\n&nbsp;\n\nFor more detailed help on a specific command use the -h option with the command, for example to get help on the cloneservicemaps command:\n\n```shell\n% opcli cloneservicemaps -h\nusage: opcli cloneservicemaps [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] --name NAME --replace REGEX REPLACEWITH [--parentlink] [--clobber]\n\nCommand-specific arguments:\n  -h, --help            show this help message and exit\n  --secure SECURE       Whether or not to verify SSL cert (default: True)\n  --name NAME           Name of Service Map to transform and clone (default: None)\n  --replace REGEX REPLACEWITH\n                        Transforming regex pattern and replacement string (option can be repeated) (default: None)\n  --parentlink          If root Service has a link to a parent, link the imported Service Map (default: False)\n  --clobber             Overwrite Service Map (i.e. with same name) if it already exists (default: False)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="credentials"></a>Credentials\n\nopcli requires credentials for most operations, either via command line arguments or an *environments.yml* file to be located in the directory where you running it.  Optionally you can specify an explicit environments file path & name using the --envfile option.  The file must follow the following format, where the name is the value you will specify to the --env option to define the URL and credentials you will use:\n\n```yaml\n- name: example1\n  url:  https://customer2name.api.opsramp.com\n  partner: msp_nnnnn\n  tenant: client_nnnnn\n  client_id: abcdefg1234567\n  client_secret: abcdefg1234567\n\n- name: example2\n  url:  https://customer2name.api.opsramp.com\n  partner: msp_nnnnn\n  tenant: client_nnnnn\n  client_id: abcdefg1234567\n  client_secret: abcdefg1234567\n```\nIf providing credentials directly on the command line, use the following options:\n\n```shell\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n  --vtoken VTOKEN       OpsRamp webhook token (only used for webhookalerts command) (default: None)\n```\nNote that you only need to provide the attributes needed for the kind of API calls you are making.  Therefore:\n* If you are making an API call that does not require a partner id (which is not needed  in most cases) you do not need to provide a *partner* value.\n* If you are not doing webhook alert posts, you would not need to specify the *vtoken* value.\n* If you are doing only webhook alert posts then you would not need *client_id* and *client_secret*.\n* If you are using the environment for a bunch of different scenarios, there is no harm in having the extra values there for the cases where they are not needed.\n\n&nbsp;\n&nbsp;\n# Commands\n\n## <a id="getalerts"></a>getalerts\nSearch for and take action on alerts\n\n```shell\nusage: opcli getalerts [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] --query QUERY [--brief] [--descr] [--count] [--filter FILTER] [--action ACTION] [--heal]\n\nCommand-specific arguments:\n  -h, --help         show this help message and exit\n  --secure SECURE    Whether or not to verify SSL cert (default: True)\n  --query QUERY      Query String to filter alerts as per https://develop.opsramp.com/resource-management/tenants-tenantid-resources-search (default: None)\n  --brief            Include only key fields in output (default: False)\n  --descr            Include the description field in results (runs *much* slower as it requires a separate api call per alert) (default: False)\n  --count            Only show the count of matching alerts (default: False)\n  --filter FILTER    Post-query filter on alerts. Python expression that will evaluate to True or False such as alert["resource"]["name"].startswith("prod") (default: None)\n  --action ACTION    Perform an action on matching alerts (Heal, acknowledge, suppress, close, unsuppress, unAcknowledge) (default: None)\n  --heal             Heal the matching alerts (i.e. send a matching Ok) (default: False)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n### Alert search criteria\nAlert search --query option uses the syntax documented [here](https://web.archive.org/web/20211024221749/https://docs.opsramp.com/api/alerts/tenants-tenantid-alerts-search/)\n\n*Note: Above link is to an Internet Archive capture of an old doc page, as the latest doc no longer lists query variables* \n### Examples\n\nSearch for all alerts with matching resource/device numeric id and metric\n\n    % opcli getalerts --env myenvname --query \'resourceIds:9798408+metrics:testmetric\' --brief\n\n\nSearch for all alerts last updated during given time range, and heal & close them\n\n    % opcli getalerts --env myenvname --query \'startDate:2000-01-01T00:00:00 0000+endDate:2020-12-01T00:00:00 0000+alertTimeBase:updated+states:Critical,Warning,Info\' --heal --action close\n\n# <a id="postalerts"></a>postalerts\nPost alerts directly to the API (using OAuth creds)\n```shell\nusage: opcli postalerts [-h] [--env ENV] [--envfile ENVFILE] [--url URL] [--client_id KEY] [--client_secret SCRT] [--tenant TENANT] [--partner PARTNER] [--secure SECURE] [--infile INFILE] [--range RANGE] [--subject SUBJECT] [--state {Critical,Warning,Info,Ok}] [--metric METRIC] [--resource RESOURCE] [--source SOURCE] [--comp COMP] [--desc DESC] [--prob PROB] [--client CLIENT]\n                        [--custom NAME VALUE]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --secure SECURE       Whether or not to verify SSL cert (default: True)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n\nPost alerts using alert content from a json file:\n  --infile INFILE       File containing a json array of alert payloads (default: None)\n  --range RANGE         An integer or range identifying which alert in the file to send (default: None)\n\nPost an alert using alert content from the command line:\n  --subject SUBJECT     Alert Subject (default: None)\n  --state {Critical,Warning,Info,Ok}\n                        Alert Current State (default: None)\n  --metric METRIC       Alert metric (default: None)\n  --resource RESOURCE   Alert Resource name (default: None)\n  --source SOURCE       Alert Source name (default: None)\n  --comp COMP           Alert Component name (default: None)\n  --desc DESC           Alert Description (default: None)\n  --prob PROB           Alert Problem Area (default: None)\n  --client CLIENT       Alert Client ID (only required if posting with a partner-level tenant (default: None)\n  --custom NAME VALUE   Alert custom attribute name and value (can repeat this option for multiple custom attributes) (default: None)\n```\n### Example\n\n    % opcli postalerts --env myenv --subject \'test alert\' --state Warning --metric testmetric --resource testhost  --comp c1 --desc mydesc --prob p1 --custom attr1 val1 --custom attr2 val2\n# <a id="webhookalerts"></a>webhookalerts\nPost alerts to a Webhook integration\n```shell\nusage: opcli webhookalerts [-h] [--url URL] [--vtoken VTOKEN] --infile INFILE [--range RANGE]\n\nCommand-specific arguments:\n  -h, --help            show this help message and exit\n  --infile INFILE       File containing an array of json alert payloads (default: None)\n  --range RANGE         An integer or range identifying which alert in the file to send (default: all)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --vtoken VTOKEN       OpsRamp webhook token (default: None)\n```\n### Example\nPost alert #5 from the specified json file (expected to contain an array of alerts), using vtoken authentication\n\n    % opcli webhookalerts --vtoken mytoken --infile myalertsamples.json --range 5\n\n# <a id="getincidents"></a>getincidents\nSearch and take action on Incidents\n```shell\nusage: opcli getincidents [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] --query QUERY [--brief] [--count] [--filter FILTER] [--resolve]\n\nCommand-specific arguments:\n  -h, --help         show this help message and exit\n  --secure SECURE    Whether or not to verify SSL cert (default: True)\n  --query QUERY      Query String to filter incidents (default: None)\n  --brief            Include only key fields in output (default: False)\n  --count            Only show the count of matching incidents (default: False)\n  --filter FILTER    Post-query filter on incidents. Python expression that will evaluate to True or False such as incident["resource"]["name"].startswith("prod") (default: None)\n  --resolve          Resolve the matching incidents (default: False)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="getresources"></a>getresources\nSearch for and take action on resources/devices\n```shell\nusage: opcli getresources [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] [--query QUERY] [--search SEARCH] [--count] [--delete] [--manage] [--filter FILTER]\n\nCommand-specific arguments:\n  -h, --help         show this help message and exit\n  --secure SECURE    Whether or not to verify SSL cert (default: True)\n  --query QUERY      Query String to filter resources as per https://develop.opsramp.com/resource-management/tenants-tenantid-resources-search (default: None)\n  --search SEARCH    Search String to filter resources as it would be entered under Resources -> Search (default: None)\n  --count            Only show the count of matching resources (default: False)\n  --delete           Delete the matching resources (default: False)\n  --manage           Manage the matching resources (default: False)\n  --filter FILTER    Post-query filter on resources. Python expression that will evaluate to True or False such as alert["resource"]["name"].startswith("prod") (default: None)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="exportservicemaps"></a>exportservicemaps    \nExport one or more full Service Map definitions to a file which can be manipulated and re-imported\n```shell\nusage: opcli exportservicemaps [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] [--name NAME] [--outdir OUTDIR] [--clobber] [--timestamp]\n\nCommand-specific arguments:\n  -h, --help         show this help message and exit\n  --secure SECURE    Whether or not to verify SSL cert (default: True)\n  --name NAME        Name of the root level Service Map/Group (export all if not specified) (default: None)\n  --outdir OUTDIR    Directory path where export will be saved (default: .)\n  --clobber          Remove/overwrite prior exports of same maps (default: False)\n  --timestamp        Include a timestamp in the Service Map dir name (default: False)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="importservicemaps"></a>importservicemaps    \nImport (and optionally transform while doing so) from a Service Map export file\n```shell\nusage: opcli importservicemaps [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] --src SRC [--replace REGEX REPLACEWITH] [--parentlink] [--clobber]\n\nCommand-specific arguments:\n  -h, --help            show this help message and exit\n  --secure SECURE       Whether or not to verify SSL cert (default: True)\n  --src SRC             Source: Path to the export file of a Service Map (default: None)\n  --replace REGEX REPLACEWITH\n                        Transforming regex pattern and replacement string (option can be repeated) (default: None)\n  --parentlink          If root Service has a link to a parent, link the imported Service Map (default: False)\n  --clobber             Overwrite Service Map (i.e. with same name) if it already exists (default: False)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="cloneservicemaps"></a>cloneservicemaps     \nCopy an existing Service Map, with transformations/replacements (useful when you have a template Service Map to re-use)\n```shell\nusage: opcli cloneservicemaps [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] --name NAME --replace REGEX REPLACEWITH [--parentlink] [--clobber]\n\nCommand-specific arguments:\n  -h, --help            show this help message and exit\n  --secure SECURE       Whether or not to verify SSL cert (default: True)\n  --name NAME           Name of Service Map to transform and clone (default: None)\n  --replace REGEX REPLACEWITH\n                        Transforming regex pattern and replacement string (option can be repeated) (default: None)\n  --parentlink          If root Service has a link to a parent, link the imported Service Map (default: False)\n  --clobber             Overwrite Service Map (i.e. with same name) if it already exists (default: False)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n### Example\n\n```shell\n% opcli cloneservicemaps --env myenv --name HUB --replace HUB HUBCOPY --parentlink\n```\n# <a id="transformsvcmap"></a>transformsvcmap      \nApply regex replacements to an exported Service Map and create a new transformed export file with the changes.  Note that no credentials are required for this command since it is just operating on local export files.\n```shell\nusage: opcli transformsvcmap [-h] src dest --replace REGEX REPLACEWITH [--clobber]\n\npositional arguments:\n  src                   Source: File path where a Service Map was previously exported\n  dest                  Destination: File path where the transformed export will be saved\n\nCommand-specific arguments:\n  -h, --help            show this help message and exit\n  --replace REGEX REPLACEWITH\n                        Transforming regex pattern and replacement string (option can be repeated) (default: None)\n  --clobber             Overwrite dest file if it already exists (default: False)\n```\n# <a id="getservicemaps"></a>getservicemaps       \nGet Service Map definitions\n```shell\nusage: opcli getservicemaps [-h] --env ENV [--secure SECURE] [--envfile ENVFILE]\n\nCommand-specific arguments:\n  -h, --help         show this help message and exit\n  --secure SECURE    Whether or not to verify SSL cert (default: True)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="getchildsvcgroups"></a>getchildsvcgroups    \nGet child Service Groups of a parent Service\n```shell\nusage: opcli getchildsvcgroups [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] --parent PARENT\n\nCommand-specific arguments:\n  -h, --help         show this help message and exit\n  --secure SECURE    Whether or not to verify SSL cert (default: True)\n  --parent PARENT    ID of the parent Service Map/Group (default: None)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="getservicegroup"></a>getservicegroup      \nGet the full definition of a Service Group\n```shell\nusage: opcli getservicegroup [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] --id ID\n\nCommand-specific arguments:\n  -h, --help         show this help message and exit\n  --secure SECURE    Whether or not to verify SSL cert (default: True)\n  --id ID            ID of the Service Map/Group (default: None)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="exportcustattrfile"></a>exportcustattrfile   \nGenerate an Excel or csv file from existing custom attribute values\n```shell\nusage: opcli exportcustattrfile [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] [--query QUERY] [--search SEARCH] [--filter FILTER] [--filename FILENAME]\n\nCommand-specific arguments:\n  -h, --help           show this help message and exit\n  --secure SECURE      Whether or not to verify SSL cert (default: True)\n  --query QUERY        Query String to filter resources as per https://develop.opsramp.com/resource-management/tenants-tenantid-resources-search (default: None)\n  --search SEARCH      Search String to filter resources as it would be entered under Resources -> Search (default: None)\n  --filter FILTER      Post-query filter on resources. Python expression that will evaluate to True or False such as alert["resource"]["name"].startswith("prod") (default: None)\n  --filename FILENAME  Name of excel file to generate (.xlsx extension will be added) (default: None)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="importcustattrfile"></a>importcustattrfile   \nImport an Excel file containing custom attribute values\n```shell\nusage: opcli importcustattrfile [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] [--commit] [--writeblanks] [--filename FILENAME]\n\nCommand-specific arguments:\n  -h, --help           show this help message and exit\n  --secure SECURE      Whether or not to verify SSL cert (default: True)\n  --commit             Make the actual updates on the platform. If not specified, only error checking and import simulation will occur. (default: False)\n  --writeblanks        When no value is provided in the spreadsheet for a resource, remove any existing value for that resource on the platform. If not specified then no action is taken for empty values. (default: False)\n  --filename FILENAME  Name of excel file to import (.xlsx extension will be added if not specified.) (default: None)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="getcustomattrs"></a>getcustomattrs       \nGet custom attribute definitions\n```shell\nusage: opcli getcustomattrs [-h] --env ENV [--secure SECURE] [--envfile ENVFILE]\n\nCommand-specific arguments:\n  -h, --help         show this help message and exit\n  --secure SECURE    Whether or not to verify SSL cert (default: True)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="getdiscoprofile"></a>getdiscoprofile      \nGet discovery profile definition\n```shell\nusage: opcli getdiscoprofile [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] --id ID --tenantId TENANTID\n\nCommand-specific arguments:\n  -h, --help           show this help message and exit\n  --secure SECURE      Whether or not to verify SSL cert (default: True)\n  --id ID              Discovery profile ID (default: None)\n  --tenantId TENANTID  Client ID or MSP ID of the tenant (default: None)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="getalertesc"></a>getalertesc          \nSearch and get Escalation Policy definitions\n```shell\nusage: opcli getalertesc [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] [--query QUERY] [--details] [--count] [--filter FILTER]\n\nCommand-specific arguments:\n  -h, --help         show this help message and exit\n  --secure SECURE    Whether or not to verify SSL cert (default: True)\n  --query QUERY      Query String to filter alerts (default: None)\n  --details          Get the full details for all matched policies (default: False)\n  --count            Only show the count of matching alerts (default: False)\n  --filter FILTER    Post-query filter on alerts. Python expression that will evaluate to True or False such as alert["resource"]["name"].startswith("prod") (default: None)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="migratealertesc"></a>migratealertesc      \nMigrate/copy Escalation Policies within same tenant or from one tenant to another\n```shell\nusage: opcli migratealertesc [-h] --env ENV [--secure SECURE] [--envfile ENVFILE] [--query QUERY] [--filter FILTER] [--preexec PREEXEC] [--postexec POSTEXEC] --to_env TO_ENV [--test] [--update] [--setactive SETACTIVE]\n\nCommand-specific arguments:\n  -h, --help            show this help message and exit\n  --secure SECURE       Whether or not to verify SSL cert (default: True)\n  --query QUERY         Query string to filter policies from source/from instance (default: None)\n  --filter FILTER       Filter for which policies to migrate. Python expression that will evaluate to True or False such as alert["resource"]["name"].startswith("prod") (default: None)\n  --preexec PREEXEC     Pre-mapped exec command (default: None)\n  --postexec POSTEXEC   Post-mapped exec command (default: None)\n  --to_env TO_ENV       Target environment to which policy definitions will be migrated. (--env option defines the source/from environment) (default: None)\n  --test                Test run only. Will check object mappings for missing items and not actually change the target instance. (default: False)\n  --update              Used for bulk updates, will only work if --env and --to_env are the same. Try to update existing policies instead of creating new ones. (default: False)\n  --setactive SETACTIVE\n                        Specify ON or OFF. Will force all policies created on the target to be ON or OFF. Otherwise will be set the same as the source. (default: None)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n```\n# <a id="clonetemplates"></a>clonetemplates\nClone monitoring templates\n```shell\n usage: opcli clonetemplates [-h] [--env ENV] [--envfile ENVFILE] [--url URL] [--client_id KEY] [--client_secret SCRT] [--tenant TENANT] [--partner PARTNER] [--secure SECURE] (--name NAME | --infile INFILE)\n                            (--prefix PREFIX | --copyname COPYNAME)\n\nCommand-specific arguments:\n  -h, --help            show this help message and exit\n  --secure SECURE       Whether or not to verify SSL cert (default: True)\n  --name NAME           Name of the Monitoring Template to clone (default: None)\n  --infile INFILE       File containing list of templates to clone (requires use of --prefix option) (default: None)\n  --prefix PREFIX       New template name will be same as original name but with this text prepended (default: None)\n  --copyname COPYNAME   New template will have this as its name (default: None)\n\nSpecify credentials via YAML file:\n  --env ENV             Name of environment to use, as defined in your environments.yml file (default: None)\n  --envfile ENVFILE     Location of environments YAML file (default: environments.yml)\n\nSpecify credentials via command line:\n  --url URL             OpsRamp API URL (default: None)\n  --client_id KEY       OpsRamp API Key (default: None)\n  --client_secret SCRT  OpsRamp API Secret (default: None)\n  --tenant TENANT       OpsRamp tenant ID (default: None)\n  --partner PARTNER     OpsRamp partner ID (usually unnecessary - only needed for partner-level API calls) (default: None)\n  ```\n\n\n',
    'author': 'Michael Friedhoff',
    'author_email': 'michael.friedhoff@opsramp.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<4.0.0',
}


setup(**setup_kwargs)
