from threading import Lock
from types import TracebackType
from typing import Dict, Optional, Type, Union

import numpy as np

from randomgen.common import BitGenerator

class RaisingLock:
    lock: Lock
    def acquire(self, blocking: bool = ..., timeout: int = ...) -> None: ...
    def release(self) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(
        self,
        type: Optional[Type[BaseException]],
        value: Optional[BaseException],
        traceback: Optional[TracebackType],
    ) -> None: ...

class RDRAND(BitGenerator):
    def __init__(self, seed: None = ..., *, retries: int = ...) -> None: ...
    @property
    def success(self) -> bool: ...
    def seed(self, seed: None = ...) -> None: ...
    def random_raw(
        self, size: Optional[int] = ..., output: bool = ...
    ) -> Union[None, int, np.ndarray]: ...
    def jumped(self, iter: int = ...) -> RDRAND: ...
    @property
    def state(self) -> Dict[str, Union[str, int, np.ndarray]]: ...
    @state.setter
    def state(self, value: Dict[str, Union[str, int, np.ndarray]]) -> None: ...
