"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const lib_1 = require("../lib");
function joined(str) {
    return str.replace(/\s+/g, '');
}
describe('DynamoDB Mapping Templates', () => {
    test('PutItem projecting all', () => {
        const template = lib_1.MappingTemplate.dynamoDbPutItem(lib_1.PrimaryKey.partition('id').is('id'), lib_1.Values.projecting());
        const rendered = joined(template.renderTemplate());
        expect(rendered).toStrictEqual(joined(`
      #set($input = $ctx.args)
      {
        "version" : "2017-02-28",
        "operation" : "PutItem",
        "key" : {
          "id" : $util.dynamodb.toDynamoDBJson($ctx.args.id)
        },
        "attributeValues": $util.dynamodb.toMapValuesJson($input)
      }`));
    });
    test('PutItem with invididual attributes', () => {
        const template = lib_1.MappingTemplate.dynamoDbPutItem(lib_1.PrimaryKey.partition('id').is('id'), lib_1.Values.attribute('val').is('ctx.args.val'));
        const rendered = joined(template.renderTemplate());
        expect(rendered).toStrictEqual(joined(`
      #set($input = {})
      $util.qr($input.put("val", ctx.args.val))
      {
        "version" : "2017-02-28",
        "operation" : "PutItem",
        "key" : {
          "id" : $util.dynamodb.toDynamoDBJson($ctx.args.id)
        },
        "attributeValues": $util.dynamodb.toMapValuesJson($input)
      }`));
    });
    test('PutItem with additional attributes', () => {
        const template = lib_1.MappingTemplate.dynamoDbPutItem(lib_1.PrimaryKey.partition('id').is('id'), lib_1.Values.projecting().attribute('val').is('ctx.args.val'));
        const rendered = joined(template.renderTemplate());
        expect(rendered).toStrictEqual(joined(`
      #set($input = $ctx.args)
      $util.qr($input.put("val", ctx.args.val))
      {
        "version" : "2017-02-28",
        "operation" : "PutItem",
        "key" : {
          "id" : $util.dynamodb.toDynamoDBJson($ctx.args.id)
        },
        "attributeValues": $util.dynamodb.toMapValuesJson($input)
      }`));
    });
});
//# sourceMappingURL=data:application/json;base64,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