import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::WorkSpaces::ConnectionAlias`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-connectionalias.html
 */
export interface CfnConnectionAliasProps {
    /**
     * `AWS::WorkSpaces::ConnectionAlias.ConnectionString`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-connectionalias.html#cfn-workspaces-connectionalias-connectionstring
     */
    readonly connectionString: string;
    /**
     * `AWS::WorkSpaces::ConnectionAlias.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-connectionalias.html#cfn-workspaces-connectionalias-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::WorkSpaces::ConnectionAlias`.
 *
 * @external
 * @cloudformationResource AWS::WorkSpaces::ConnectionAlias
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-connectionalias.html
 */
export declare class CfnConnectionAlias extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::WorkSpaces::ConnectionAlias";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConnectionAlias;
    /**
     * @external
     * @cloudformationAttribute AliasId
     */
    readonly attrAliasId: string;
    /**
     * @external
     * @cloudformationAttribute Associations
     */
    readonly attrAssociations: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute ConnectionAliasState
     */
    readonly attrConnectionAliasState: string;
    /**
     * `AWS::WorkSpaces::ConnectionAlias.ConnectionString`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-connectionalias.html#cfn-workspaces-connectionalias-connectionstring
     */
    connectionString: string;
    /**
     * `AWS::WorkSpaces::ConnectionAlias.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-connectionalias.html#cfn-workspaces-connectionalias-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::WorkSpaces::ConnectionAlias`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectionAliasProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::WorkSpaces::ConnectionAlias`.
 *
 * @external
 * @cloudformationResource AWS::WorkSpaces::ConnectionAlias
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-connectionalias.html
 */
export declare namespace CfnConnectionAlias {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-connectionalias-connectionaliasassociation.html
     */
    interface ConnectionAliasAssociationProperty {
        /**
         * `CfnConnectionAlias.ConnectionAliasAssociationProperty.AssociatedAccountId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-connectionalias-connectionaliasassociation.html#cfn-workspaces-connectionalias-connectionaliasassociation-associatedaccountid
         */
        readonly associatedAccountId?: string;
        /**
         * `CfnConnectionAlias.ConnectionAliasAssociationProperty.AssociationStatus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-connectionalias-connectionaliasassociation.html#cfn-workspaces-connectionalias-connectionaliasassociation-associationstatus
         */
        readonly associationStatus?: string;
        /**
         * `CfnConnectionAlias.ConnectionAliasAssociationProperty.ConnectionIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-connectionalias-connectionaliasassociation.html#cfn-workspaces-connectionalias-connectionaliasassociation-connectionidentifier
         */
        readonly connectionIdentifier?: string;
        /**
         * `CfnConnectionAlias.ConnectionAliasAssociationProperty.ResourceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-connectionalias-connectionaliasassociation.html#cfn-workspaces-connectionalias-connectionaliasassociation-resourceid
         */
        readonly resourceId?: string;
    }
}
/**
 * Properties for defining a `AWS::WorkSpaces::Workspace`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html
 */
export interface CfnWorkspaceProps {
    /**
     * `AWS::WorkSpaces::Workspace.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-bundleid
     */
    readonly bundleId: string;
    /**
     * `AWS::WorkSpaces::Workspace.DirectoryId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-directoryid
     */
    readonly directoryId: string;
    /**
     * `AWS::WorkSpaces::Workspace.UserName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-username
     */
    readonly userName: string;
    /**
     * `AWS::WorkSpaces::Workspace.RootVolumeEncryptionEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-rootvolumeencryptionenabled
     */
    readonly rootVolumeEncryptionEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::WorkSpaces::Workspace.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::WorkSpaces::Workspace.UserVolumeEncryptionEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-uservolumeencryptionenabled
     */
    readonly userVolumeEncryptionEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::WorkSpaces::Workspace.VolumeEncryptionKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-volumeencryptionkey
     */
    readonly volumeEncryptionKey?: string;
    /**
     * `AWS::WorkSpaces::Workspace.WorkspaceProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-workspaceproperties
     */
    readonly workspaceProperties?: CfnWorkspace.WorkspacePropertiesProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::WorkSpaces::Workspace`.
 *
 * @external
 * @cloudformationResource AWS::WorkSpaces::Workspace
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html
 */
export declare class CfnWorkspace extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::WorkSpaces::Workspace";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWorkspace;
    /**
     * `AWS::WorkSpaces::Workspace.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-bundleid
     */
    bundleId: string;
    /**
     * `AWS::WorkSpaces::Workspace.DirectoryId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-directoryid
     */
    directoryId: string;
    /**
     * `AWS::WorkSpaces::Workspace.UserName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-username
     */
    userName: string;
    /**
     * `AWS::WorkSpaces::Workspace.RootVolumeEncryptionEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-rootvolumeencryptionenabled
     */
    rootVolumeEncryptionEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::WorkSpaces::Workspace.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::WorkSpaces::Workspace.UserVolumeEncryptionEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-uservolumeencryptionenabled
     */
    userVolumeEncryptionEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::WorkSpaces::Workspace.VolumeEncryptionKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-volumeencryptionkey
     */
    volumeEncryptionKey: string | undefined;
    /**
     * `AWS::WorkSpaces::Workspace.WorkspaceProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-workspaceproperties
     */
    workspaceProperties: CfnWorkspace.WorkspacePropertiesProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::WorkSpaces::Workspace`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWorkspaceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::WorkSpaces::Workspace`.
 *
 * @external
 * @cloudformationResource AWS::WorkSpaces::Workspace
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html
 */
export declare namespace CfnWorkspace {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html
     */
    interface WorkspacePropertiesProperty {
        /**
         * `CfnWorkspace.WorkspacePropertiesProperty.ComputeTypeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-computetypename
         */
        readonly computeTypeName?: string;
        /**
         * `CfnWorkspace.WorkspacePropertiesProperty.RootVolumeSizeGib`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-rootvolumesizegib
         */
        readonly rootVolumeSizeGib?: number;
        /**
         * `CfnWorkspace.WorkspacePropertiesProperty.RunningMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-runningmode
         */
        readonly runningMode?: string;
        /**
         * `CfnWorkspace.WorkspacePropertiesProperty.RunningModeAutoStopTimeoutInMinutes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-runningmodeautostoptimeoutinminutes
         */
        readonly runningModeAutoStopTimeoutInMinutes?: number;
        /**
         * `CfnWorkspace.WorkspacePropertiesProperty.UserVolumeSizeGib`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-uservolumesizegib
         */
        readonly userVolumeSizeGib?: number;
    }
}
