from enum import Enum
from matplotlib.colors import LinearSegmentedColormap, Normalize

class PrbsEnum(Enum):
    PRBS7  = 7
    PRBS9  = 9
    PRBS11 = 11
    PRBS13 = 13
    PRBS15 = 15
    PRBS31 = 31


class ConstellationEnum(Enum):
    NRZ  = 0
    OOK  = 1
    PAM4 = 2


class CodingEnum(Enum):
    UNCODED = 0
    GRAY    = 1

# COLORMAP = LinearSegmentedColormap("",{
#     'red':   [(  0.0,     0.0,    0.0),
#               ( 1/20,  50/255, 50/255),
#               ( 1/18,  16/255, 16/255),
#               ( 1/16, 236/255, 236/255),
#               ( 1/14, 214/255, 214/255),
#               ( 1/13, 191/255, 191/255),
#               ( 1/12, 230/255, 230/255),
#               ( 1/11, 230/255, 230/255),
#               ( 1/10, 233/255, 233/255),
#               ( 3/10, 233/255, 233/255),
#               ( 6/10, 244/255, 244/255),
#               (11/11, 255/255, 255/255)],
#     'green': [(  0.0,     0.0,     0.0),
#               ( 1/20, 194/255, 194/255),
#               ( 1/18,  69/255,  69/255),
#               ( 1/16,  47/255,  47/255),
#               ( 1/14,  36/255,  36/255),
#               ( 1/13,  21/255,  21/255),
#               ( 1/12, 124/255, 124/255),
#               ( 1/11, 132/255, 132/255),
#               ( 1/10, 168/255, 168/255),
#               ( 3/10, 213/255, 213/255),
#               ( 6/10, 234/255, 234/255),
#               (11/11, 255/255, 255/255)],
#     'blue': [(   0.0,     0.0,     0.0),
#               ( 1/20,  45/255,  45/255),
#               ( 1/18, 201/255, 201/255),
#               ( 1/16, 173/255, 173/255),
#               ( 1/14, 111/255, 111/255),
#               ( 1/13,  17/255,  17/255),
#               ( 1/12,   3/255,   3/255),
#               ( 1/11,   2/255,   2/255),
#               ( 1/10,   0/255,   0/255),
#               ( 3/10,  39/255,  39/255),
#               ( 6/10, 146/255, 146/255),
#               (11/11, 255/255, 255/255)]})

EYE_COLORMAP = LinearSegmentedColormap("",{
    'red':   [(  0.0,     0.0,    0.0),
              ( 1/30,  50/255, 50/255),
              ( 1/24,  16/255, 16/255),
              ( 1/22, 236/255, 236/255),
              ( 1/18, 191/255, 191/255),
              ( 2/12, 233/255, 233/255),
              ( 4/10, 244/255, 244/255),
              (11/11, 255/255, 255/255)],
    'green': [(  0.0,     0.0,     0.0),
              ( 1/30, 194/255, 194/255),
              ( 1/24,  69/255,  69/255),
              ( 1/22,  47/255,  47/255),
              ( 1/18,  21/255,  21/255),
              ( 2/12, 168/255, 168/255),
              ( 4/10, 234/255, 234/255),
              (11/11, 255/255, 255/255)],
    'blue': [(   0.0,     0.0,     0.0),
              ( 1/30,  45/255,  45/255),
              ( 1/24, 201/255, 201/255),
              ( 1/22, 173/255, 173/255),
              ( 1/18,  17/255,  17/255),
              ( 2/12,   0/255,   0/255),
              ( 4/10, 146/255, 146/255),
              (11/11, 255/255, 255/255)]})

