from __future__ import annotations
from logging import Logger
from ..accessory import Accessory as Accessory
from .contact import Contact as Contact
from .image import Image as Image
from .mini_program import MiniProgram as MiniProgram
from .room import Room as Room
from .url_link import UrlLink as UrlLink
from _typeshed import Incomplete
from datetime import datetime
from typing import List, Optional, Union, overload
from wechaty.exceptions import WechatyOperationError as WechatyOperationError, WechatyPayloadError as WechatyPayloadError
from wechaty.user.contact_self import ContactSelf as ContactSelf
from wechaty.utils import timestamp_to_date as timestamp_to_date
from wechaty_puppet import FileBox, MessagePayload, MessageType

log: Logger 
SUPPORTED_MESSAGE_FILE_TYPES: List[MessageType]

class Message(Accessory[MessagePayload]):
    Type: MessageType 
    message_id: str 

    def __init__(self, message_id: str) -> None: ...
    def message_type(self) -> MessageType: ...

    @overload
    async def say(self, msg: str) -> Optional[Message]: ...
    @overload
    async def say(self, msg: str, mention_ids: List[str] = ...) -> Optional[Message]: ...
    @overload
    async def say(self, msg: Union[Contact, FileBox, UrlLink, MiniProgram]) -> Optional[Message]: ...

    @classmethod
    async def find(cls, talker_id: Optional[str] = ..., message_id: Optional[str] = ..., room_id: Optional[str] = ..., text: Optional[str] = ..., to_id: Optional[str] = ..., message_type: Optional[MessageType] = ...) -> Optional[Message]: ...
    @classmethod
    async def find_all(cls, talker_id: Optional[str] = ..., message_id: Optional[str] = ..., room_id: Optional[str] = ..., text: Optional[str] = ..., to_id: Optional[str] = ..., message_type: Optional[MessageType] = ...) -> List[Message]: ...
    def talker(self) -> Contact: ...
    def to(self) -> Optional[Contact]: ...
    def room(self) -> Optional[Room]: ...
    def chatter(self) -> Union[Room, Contact]: ...
    def text(self) -> str: ...
    async def to_recalled(self) -> Message: ...
    async def recall(self) -> bool: ...
    @classmethod
    def load(cls, message_id: str) -> Message: ...
    def type(self) -> MessageType: ...
    def is_self(self) -> bool: ...
    async def mention_list(self) -> List[Contact]: ...
    async def mention_text(self) -> str: ...
    async def mention_self(self) -> bool: ...
    payload: Incomplete
    async def ready(self) -> None: ...
    async def forward(self, to: Union[Room, Contact]) -> None: ...
    def date(self) -> datetime: ...
    def age(self) -> int: ...
    async def to_file_box(self) -> FileBox: ...
    def to_image(self) -> Image: ...
    async def to_contact(self) -> Contact: ...
    async def to_url_link(self) -> UrlLink: ...
    async def to_mini_program(self) -> MiniProgram: ...
