# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cyc_next_app',
 'cyc_next_app.lib.@jupyter-widgets.schema',
 'cyc_next_app.server',
 'cyc_next_app.server.python',
 'cyc_next_app.server.python.cassist',
 'cyc_next_app.server.python.code_editor',
 'cyc_next_app.server.python.dataframe_manager',
 'cyc_next_app.server.python.experiment_manager',
 'cyc_next_app.server.python.file_explorer',
 'cyc_next_app.server.python.file_manager',
 'cyc_next_app.server.python.libs',
 'cyc_next_app.server.python.model_manager',
 'cyc_next_app.server.python.project_manager',
 'cyc_next_app.server.python.user_space',
 'cyc_next_app.server.python.user_space.ipython',
 'cyc_next_app.server.tests',
 'cyc_next_app.server.tests.test_servers']

package_data = \
{'': ['*'],
 'cyc_next_app': ['lib/@jupyter-widgets/base/*',
                  'lib/@jupyter-widgets/base/css/*',
                  'lib/@jupyter-widgets/base/lib/*',
                  'lib/@jupyter-widgets/controls/*',
                  'lib/@jupyter-widgets/controls/css/*',
                  'lib/@jupyter-widgets/controls/lib/*',
                  'lib/@jupyter-widgets/controls/lib/phosphor/*',
                  'lib/@jupyter-widgets/html-manager/*',
                  'lib/@jupyter-widgets/html-manager/css/*',
                  'lib/@jupyter-widgets/html-manager/lib/*',
                  'lib/@jupyter-widgets/jupyterlab-manager/*',
                  'lib/@jupyter-widgets/jupyterlab-manager/lib/*',
                  'lib/@jupyter-widgets/jupyterlab-manager/schema/*',
                  'lib/@jupyter-widgets/output/*',
                  'lib/@jupyter-widgets/output/lib/*',
                  'lib/cassist/*',
                  'lib/codemirror/autocomplete-lsp/*',
                  'lib/codemirror/autocomplete-lsp/autocomplete/*',
                  'lib/codemirror/basic-setup/*',
                  'lib/codemirror/grammar/*',
                  'lib/components/*',
                  'lib/components/code-panel/*',
                  'lib/components/dataframe-manager/*',
                  'lib/components/error-boundary/*',
                  'lib/components/file-manager/*',
                  'lib/components/kernel-manager/*',
                  'lib/components/libs/*',
                  'lib/components/richoutput-panel/*',
                  'lib/components/richoutput-panel/data-panel/*',
                  'lib/components/richoutput-panel/experiment-panel/*',
                  'lib/components/richoutput-panel/model-panel/*',
                  'lib/components/richoutput-panel/result-panel/*',
                  'lib/components/richoutput-panel/summary-panel/*',
                  'lib/components/sidebar/*',
                  'lib/components/tests/*',
                  'lib/interfaces/*',
                  'pages/*',
                  'public/*',
                  'public/icons/*',
                  'redux/*',
                  'redux/actions/*',
                  'redux/reducers/*',
                  'redux/store/*',
                  'styles/*',
                  'theme/*'],
 'cyc_next_app.lib.@jupyter-widgets.schema': ['v1/*', 'v2/*'],
 'cyc_next_app.server': ['build/*', 'ls/*', 'routes/*']}

install_requires = \
['cnextlib>=0.2.0,<0.3.0',
 'jupyter-client>=7.2.2,<8.0.0',
 'jupyterlab>=3.3.4,<4.0.0',
 'matplotlib>=3.5.1,<4.0.0',
 'mlflow>=1.25.1,<2.0.0',
 'multipledispatch>=0.6.0,<0.7.0',
 'netron>=5.7.8,<6.0.0',
 'pandas==1.3.5',
 'plotly>=5.7.0,<6.0.0',
 'python-language-server>=0.36.2,<0.37.0',
 'requests>=2.27.1,<3.0.0',
 'send2trash>=1.8.0,<2.0.0',
 'simplejson>=3.17.6,<4.0.0',
 'zmq>=0.0.0,<0.0.1']

entry_points = \
{'console_scripts': ['cnext-init = cyc_next_app.__main__:main',
                     'cnext-path = cyc_next_app.__main__:path',
                     'cnext-run = cyc_next_app.__main__:start']}

setup_kwargs = {
    'name': 'cnext',
    'version': '0.4.4',
    'description': 'improve your AI work follow',
    'long_description': '# CNext Instructions\n\n[Website] - [Documentation] - [Docker Image] - [Overview Video]\n## Setup and run the CNext workspace\n\n\u200b\nCNext is a data-centric workspace for DS and AI. Our workspace is meant to consolidate the most common tasks performed by data scientists and ML engineers. At a high level our workspace allows for:\n\n-   Data exploration & transformation\n-   Model development / exploration\n-   Production code generation\n-   Dashboard & App Generation\n-   Experiment Management\n## Features\n\n-   Interactive Python coding envrionment with native Python output (think Jupyter replacement)\n-   Smart code suggestion (categorical values and column names)\n-   Interactive data exploration\n-   Automative visualizations\n-   Experiment and model management\n-   Instant dashboarding\n    \u200b\n## Installation via Docker\n\nStep 1: `Download` [cnext] folder and `extract`\n\nStep 2: `setup` [Docker] on your computer\n\nStep 3: Run `docker login` login with your docker account\n\nStep 4: Point destination command to `cnext` directory\n\nStep 5: Run command `docker-compose up -d`\n\u200b\n\n-   The web application will launch at : `http://localhost:CLIENT_PORT` or `http://127.0.0.1:CLIENT_PORT/` (CLIENT_PORT default is 3000)\n-   To stop the application: `docker-compose down`\n-   Note: Pay attention at `CLIENT_PORT`, and `SERVER_PORT` in `.env` file (you will have to change these ports if you already use them on your machine, by default they are 3000 and 4000 respectively)\n    \u200b\n\n## Installation via Pip\n\n\u200b\nStep 1: `Download` [cnext] folder and `extract`\n\nStep 2: Make sure `Nodejs` is available in your computer (try `npm --version` and make sure it work)\n\nStep 3: `run` command `pip install cnext`\n\nStep 4: `run` command `cnext-init`\n\nStep 5: `run` command `cnext-path`\n\n-   Input `Skywalker folder directory path` and hit `Enter` (Example `C:/Skywalker`)\n    \u200b\n    \nStep 6 `run` command `cnext-run`\n    \u200b\n-   Web application will launch at : `http://localhost:CLIENT_PORT` or `http://127.0.0.1:CLIENT_PORT/` (CLIENT_PORT default is 3000)\n-   Stop application: `Ctrl + c | Command + c`\n-   Note: Pay attention at `CLIENT_PORT`, and `SERVER_PORT` in `.env` file (you will have to change these ports if you already use them on your machine, by default they are 3000 and 4000 respectively)\n\n## License\n\nCYCAI\n\n**Great Software, Hell Yeah!**\n\n[website]: https://www.cnext.io/\n[docker image]: https://hub.docker.com/r/cycai/cnext\n[documentation]: https://internal-lace-ae4.notion.site/Product-Documentation-0dd58ea1cfe14dfab3666c5ec633ae96\n[overview video]: https://youtu.be/5eWPkQIUfZw\n[cnext]: https://drive.google.com/file/d/1w4MU3nr0E14PAS_5NmruuoMSfQeE5MLK\n[docker]: https://www.docker.com/products/docker-desktop/\n',
    'author': 'cycai company',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://cyc-ai.com/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9',
}


setup(**setup_kwargs)
