from setuptools import setup, find_packages

setup(
    name='aihandler',
    version='1.8.11',
    author='Capsize LLC',
    description="AI Handler: An engine which wraps certain huggingface models",
    long_description=open("README.md", "r", encoding="utf-8").read(),
    long_description_content_type="",
    keywords="ai, chatbot, chat, ai",
    license="AGPL-3.0",
    author_email="contact@capsize.gg",
    url="https://github.com/w4ffl35/aihandler",
    package_dir={"": "src"},
    packages=find_packages("src"),
    include_package_data=True,
    python_requires=">=3.10.0",
    install_requires=[
        "torch==1.13.1",
        "torchvision==0.14.1",
        "torchaudio==0.13.1",
        "lightning==1.9.0",
        "pytorch-lightning==1.9.1",
        "nvidia-pyindex",
        "nvidia-tensorrt==8.4.3.1",
        "tensorflow==2.9.3",
        "triton==2.0.0.dev20221202",
        "pyre-extensions==0.0.23",
        "einops==0.6.0",
        "ninja==1.11.1",
        "JIT==0.2.7",
        "xformers==0.0.16",
        "pillow==9.4.0",
        "ninja==1.11.1",
        "fernet==1.0.1",
        "pillow==9.4.0",
        "safetensors==0.2.7",
        "accelerate==0.15.0",
        "diffusers==0.14.0",
        "transformers==4.26.0",
        "bitsandbytes==0.36.0.post2",
        "numpy==1.23.4",
        "pyinstaller==5.7.0",
        "scipy==1.10.0",
        "opencv-python==4.7.0.68",
        "deepspeed==0.8.0",
        "zstandard",
        "pyqt6==6.4.2",
        "matplotlib",
        "controlnet_aux",
        "pyqtdarktheme",
        "spacy==3.5.1",
    ],
    extras_require={},
)
