[![image](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/qpv-research-group/solcore5/develop?urlpath=lab)
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-26-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->
[![image](https://zenodo.org/badge/DOI/10.5281/zenodo.1185316.svg)](https://doi.org/10.5281/zenodo.1185316)
[![image](https://img.shields.io/badge/License-LGPLv3-blue.svg)](http://www.gnu.org/licenses/lgpl.html)
[![Documentation Status](http://readthedocs.org/projects/solcore5/badge/?version=latest)](http://solcore5.readthedocs.io/en/latest/?badge=latest)
![Solcore](https://github.com/qpv-research-group/solcore5/workflows/Solcore/badge.svg)
[![codecov](https://codecov.io/gh/qpv-research-group/solcore5/branch/develop/graph/badge.svg)](https://codecov.io/gh/qpv-research-group/solcore5)
[![Codacy Badge](https://api.codacy.com/project/badge/Grade/a1d2e6f702e64d878a67dcf85ce9b3b7)](https://app.codacy.com/gh/qpv-research-group/solcore5?utm_source=github.com&utm_medium=referral&utm_content=qpv-research-group/solcore5&utm_campaign=Badge_Grade_Settings)


Solcore
=======

**Solcore** was born as a modular set of tools, written (almost) entirely in Python 3, to address some of the task we had to solve more. With time, however, it has evolved as a complete semiconductor solver able of modelling the optical and electrical properties of a wide range of solar cells, from quantum well devices to multi-junction solar cells.

Please, visit [Solcore\'s Documentation](http://docs.solcore.solar), the [Tutorial](docs/source/Examples/tutorial.rst) for a step-by-step example of how to use *Solcore* to model a solar cell and also check the [Examples folder](examples) for more specific information and examples of usage.

![](docs/source/Infographics.jpg)

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://www.imperial.ac.uk/admin-services/ict/self-service/research-support/rcs/research-software-engineering/"><img src="https://avatars.githubusercontent.com/u/6095790?v=4?s=100" width="100px;" alt="Diego Alonso Álvarez"/><br /><sub><b>Diego Alonso Álvarez</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=dalonsoa" title="Code">💻</a> <a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3Adalonsoa" title="Bug reports">🐛</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=dalonsoa" title="Documentation">📖</a> <a href="#example-dalonsoa" title="Examples">💡</a> <a href="#ideas-dalonsoa" title="Ideas, Planning, & Feedback">🤔</a> <a href="#infra-dalonsoa" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#maintenance-dalonsoa" title="Maintenance">🚧</a> <a href="https://github.com/qpv-research-group/solcore5/pulls?q=is%3Apr+reviewed-by%3Adalonsoa" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=dalonsoa" title="Tests">⚠️</a> <a href="#data-dalonsoa" title="Data">🔣</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.qpvgroup.org/phoebe-pearce"><img src="https://avatars.githubusercontent.com/u/25822065?v=4?s=100" width="100px;" alt="Phoebe Pearce"/><br /><sub><b>Phoebe Pearce</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=phoebe-p" title="Code">💻</a> <a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3Aphoebe-p" title="Bug reports">🐛</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=phoebe-p" title="Documentation">📖</a> <a href="#example-phoebe-p" title="Examples">💡</a> <a href="#ideas-phoebe-p" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-phoebe-p" title="Maintenance">🚧</a> <a href="https://github.com/qpv-research-group/solcore5/pulls?q=is%3Apr+reviewed-by%3Aphoebe-p" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=phoebe-p" title="Tests">⚠️</a> <a href="#data-phoebe-p" title="Data">🔣</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/twmwilson"><img src="https://avatars.githubusercontent.com/u/11062839?v=4?s=100" width="100px;" alt="Tom Wilson"/><br /><sub><b>Tom Wilson</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=twmwilson" title="Code">💻</a> <a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3Atwmwilson" title="Bug reports">🐛</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=twmwilson" title="Documentation">📖</a> <a href="#example-twmwilson" title="Examples">💡</a> <a href="#ideas-twmwilson" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/qpv-research-group/solcore5/pulls?q=is%3Apr+reviewed-by%3Atwmwilson" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=twmwilson" title="Tests">⚠️</a> <a href="#data-twmwilson" title="Data">🔣</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.qpvgroup.org"><img src="https://avatars.githubusercontent.com/u/128552?v=4?s=100" width="100px;" alt="Ned Ekins-Daukes"/><br /><sub><b>Ned Ekins-Daukes</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=iclned" title="Documentation">📖</a> <a href="#example-iclned" title="Examples">💡</a> <a href="#ideas-iclned" title="Ideas, Planning, & Feedback">🤔</a> <a href="#financial-iclned" title="Financial">💵</a> <a href="https://github.com/qpv-research-group/solcore5/pulls?q=is%3Apr+reviewed-by%3Aiclned" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=iclned" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MarkusFF"><img src="https://avatars.githubusercontent.com/u/1842361?v=4?s=100" width="100px;" alt="MarkusFF"/><br /><sub><b>MarkusFF</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=MarkusFF" title="Code">💻</a> <a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3AMarkusFF" title="Bug reports">🐛</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=MarkusFF" title="Documentation">📖</a> <a href="#example-MarkusFF" title="Examples">💡</a> <a href="#ideas-MarkusFF" title="Ideas, Planning, & Feedback">🤔</a> <a href="#design-MarkusFF" title="Design">🎨</a> <a href="#data-MarkusFF" title="Data">🔣</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jcohen02"><img src="https://avatars.githubusercontent.com/u/8027703?v=4?s=100" width="100px;" alt="Jeremy Cohen"/><br /><sub><b>Jeremy Cohen</b></sub></a><br /><a href="#infra-jcohen02" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/PieceMaker"><img src="https://avatars.githubusercontent.com/u/4616735?v=4?s=100" width="100px;" alt="Jonathan Adams"/><br /><sub><b>Jonathan Adams</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=PieceMaker" title="Tests">⚠️</a> <a href="https://github.com/qpv-research-group/solcore5/pulls?q=is%3Apr+reviewed-by%3APieceMaker" title="Reviewed Pull Requests">👀</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mhrownaghi"><img src="https://avatars.githubusercontent.com/u/56091044?v=4?s=100" width="100px;" alt="Mohammad Hosein Ronaghi"/><br /><sub><b>Mohammad Hosein Ronaghi</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=mhrownaghi" title="Tests">⚠️</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=mhrownaghi" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/federikovi"><img src="https://avatars.githubusercontent.com/u/17218213?v=4?s=100" width="100px;" alt="Federica Trevisan"/><br /><sub><b>Federica Trevisan</b></sub></a><br /><a href="#example-federikovi" title="Examples">💡</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Artyko"><img src="https://avatars.githubusercontent.com/u/30906495?v=4?s=100" width="100px;" alt="Artyko"/><br /><sub><b>Artyko</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=Artyko" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/emmanuel-carreira"><img src="https://avatars.githubusercontent.com/u/30865344?v=4?s=100" width="100px;" alt="Emmanuel Carreira"/><br /><sub><b>Emmanuel Carreira</b></sub></a><br /><a href="#example-emmanuel-carreira" title="Examples">💡</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://nimishverma.medium.com/"><img src="https://avatars.githubusercontent.com/u/17747722?v=4?s=100" width="100px;" alt="Nimish Verma"/><br /><sub><b>Nimish Verma</b></sub></a><br /><a href="#example-NimishVerma" title="Examples">💡</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/P-Tillmann"><img src="https://avatars.githubusercontent.com/u/23280737?v=4?s=100" width="100px;" alt="Peter Tillmann"/><br /><sub><b>Peter Tillmann</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=P-Tillmann" title="Code">💻</a> <a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3AP-Tillmann" title="Bug reports">🐛</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=P-Tillmann" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jmllorens"><img src="https://avatars.githubusercontent.com/u/1357438?v=4?s=100" width="100px;" alt="jmllorens"/><br /><sub><b>jmllorens</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=jmllorens" title="Code">💻</a> <a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3Ajmllorens" title="Bug reports">🐛</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=jmllorens" title="Tests">⚠️</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Abelarm"><img src="https://avatars.githubusercontent.com/u/6976921?v=4?s=100" width="100px;" alt="Luigi Giugliano"/><br /><sub><b>Luigi Giugliano</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=Abelarm" title="Code">💻</a> <a href="#infra-Abelarm" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/qpv-research-group/solcore5/commits?author=Abelarm" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MichaelNOz"><img src="https://avatars.githubusercontent.com/u/39320219?v=4?s=100" width="100px;" alt="michael_oz"/><br /><sub><b>michael_oz</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=MichaelNOz" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/hrishikesh-suresh-881020136"><img src="https://avatars.githubusercontent.com/u/30840337?v=4?s=100" width="100px;" alt="Hrishikesh Suresh"/><br /><sub><b>Hrishikesh Suresh</b></sub></a><br /><a href="#example-hrishikeshSuresh" title="Examples">💡</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jscooksey"><img src="https://avatars.githubusercontent.com/u/18700514?v=4?s=100" width="100px;" alt="Justin Cooksey"/><br /><sub><b>Justin Cooksey</b></sub></a><br /><a href="#example-jscooksey" title="Examples">💡</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/yuriy-os"><img src="https://avatars.githubusercontent.com/u/12021598?v=4?s=100" width="100px;" alt="Yura Osychenko"/><br /><sub><b>Yura Osychenko</b></sub></a><br /><a href="#design-yuriy-os" title="Design">🎨</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/canns99"><img src="https://avatars.githubusercontent.com/u/70144228?v=4?s=100" width="100px;" alt="canns99"/><br /><sub><b>canns99</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3Acanns99" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/AndiPOz"><img src="https://avatars.githubusercontent.com/u/66819562?v=4?s=100" width="100px;" alt="AndiPOz"/><br /><sub><b>AndiPOz</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3AAndiPOz" title="Bug reports">🐛</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://jaib.home.blog"><img src="https://avatars.githubusercontent.com/u/31744868?v=4?s=100" width="100px;" alt="Jai Agarwal"/><br /><sub><b>Jai Agarwal</b></sub></a><br /><a href="#example-jaibhageria" title="Examples">💡</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jkrich"><img src="https://avatars.githubusercontent.com/u/29390895?v=4?s=100" width="100px;" alt="jkrich"/><br /><sub><b>jkrich</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/commits?author=jkrich" title="Code">💻</a> <a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3Ajkrich" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Rushil17D070020"><img src="https://avatars.githubusercontent.com/u/89643859?v=4?s=100" width="100px;" alt="Rushil17D070020"/><br /><sub><b>Rushil17D070020</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3ARushil17D070020" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/etervo"><img src="https://avatars.githubusercontent.com/u/51174646?v=4?s=100" width="100px;" alt="Eric Tervo"/><br /><sub><b>Eric Tervo</b></sub></a><br /><a href="https://github.com/qpv-research-group/solcore5/issues?q=author%3Aetervo" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/eli-schwartz"><img src="https://avatars.githubusercontent.com/u/6551424?v=4?s=100" width="100px;" alt="Eli Schwartz"/><br /><sub><b>Eli Schwartz</b></sub></a><br /><a href="#infra-eli-schwartz" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!