# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['beaupy', 'beaupy.spinners']

package_data = \
{'': ['*']}

install_requires = \
['emoji>=2.0.0,<3.0.0',
 'pyproject-flake8==0.0.1a4',
 'readchar>=4.0.0,<5.0.0',
 'rich>=12.2.0,<13.0.0']

setup_kwargs = {
    'name': 'beaupy',
    'version': '1.3.1',
    'description': 'A library of elements for interactive TUIs in Python',
    'long_description': '# BeauPy\n\n![beaupy](https://user-images.githubusercontent.com/47027005/185082011-cb588f57-d38f-42d8-8312-3981ae1bc479.png)\n\n> A Python library of interactive CLI elements you have been looking for\n\n---\n\n[![Tests](https://github.com/petereon/beaupy/actions/workflows/python-test.yml/badge.svg)](https://github.com/petereon/beaupy/actions/workflows/python-test.yml)\n[![Lint](https://github.com/petereon/beaupy/actions/workflows/python-lint.yml/badge.svg)](https://github.com/petereon/beaupy/actions/workflows/python-lint.yml)\n[![codecov](https://codecov.io/gh/petereon/beaupy/branch/master/graph/badge.svg?token=HSG6MGTXBC)](https://codecov.io/gh/petereon/beaupy)\n[![Maintainability Rating](https://sonarcloud.io/api/project_badges/measure?project=petereon_beaupy&metric=sqale_rating)](https://sonarcloud.io/summary/new_code?id=petereon_beaupy)\n[![Security Rating](https://sonarcloud.io/api/project_badges/measure?project=petereon_beaupy&metric=security_rating)](https://sonarcloud.io/summary/new_code?id=petereon_beaupy)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/beaupy?color=g&label=%F0%9F%93%A5%20Downloads)\n\nFor documentation but more and prettier see [**here**](https://petereon.github.io/beaupy/)\n\n## Acknowledgment\n\nBeauPy stands on the shoulders of giants. It is based on another library with which it shares some of the source code, [`cutie`](https://github.com/kamik423/cutie), developed by [Kamik423](https://github.com/Kamik423). It has begun as a fork but has since diverged into it\'s own thing and as such, detached from the original repository.\n\n## Overview\n\n**BeauPy** implements a number of common interactive elements:\n\n| Function                                                                                                  | Functionality                                                                              |\n|:----------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------|\n| [`select`](https://petereon.github.io/beaupy/api/#select)                        | Prompt to pick a choice from a list                                                        |\n| [`select_multiple`](https://petereon.github.io/beaupy/api/#select_multiple)      | Prompt to select one or multiple choices from a list                                       |\n| [`confirm`](https://petereon.github.io/beaupy/api/#confirm)                      | Prompt with a question and yes/no options                                                  |\n| [`prompt`](https://petereon.github.io/beaupy/api/#prompt)                        | Prompt that takes free input with optional validation, type conversion and input hiding |\n\n## Getting Started\n\n**BeauPy** is a library of interactive TUI elements for CLI applications.\n\n**BeauPy** is\n\n- [rich](https://rich.readthedocs.io/en/stable/) friendly\n- stylable\n- opinionated\n- configurable\n\n### Installation\n\nFrom PyPI:\n\n```sh\npip install beaupy\n```\n\nFrom source:\n\n```sh\ngit clone https://github.com/petereon/beaupy.git\npoetry build\npip install ./dist/beaupy-{{some-version}}-py3-none-any.whl\n```\n\n### Example\n\n![example](https://raw.githubusercontent.com/petereon/beaupy/master/example.gif)\n\nTUI elements shown in the above gif are the result of the follwing code:\n\n```python\nimport time\nfrom beaupy import *\nfrom beaupy.spinners import *\n\ndef main():\n    """Main."""\n    # Confirm a dialog\n    if confirm("Will you take the ring to Mordor?"):\n        names = [\n            "Frodo Baggins",\n            "Samwise Gamgee",\n            "Legolas",\n            "Aragorn",\n            "[red]Sauron[/red]",\n        ]\n        console.print("Who are you?")\n        # Choose one item from a list\n        name = select(names, cursor="🢧", cursor_style="cyan")\n        console.print(f"Alámenë, {name}")\n        \n        \n        item_options = [\n            "The One Ring",\n            "Dagger",\n            "Po-tae-toes",\n            "Lightsaber (Wrong franchise! Nevermind, roll with it!)",\n        ]\n        console.print("What do you bring with you?")\n        # Choose multiple options from a list\n        items = select_multiple(item_options, tick_character=\'🎒\', ticked_indices=[0], maximal_count=3)\n        \n        potato_count = 0\n        if "Po-tae-toes" in items:\n            # Prompt with type conversion and validation\n            potato_count = prompt(\'How many potatoes?\', target_type=int, validator=lambda count: count > 0)\n        \n        # Spinner to show while doing some work\n        spinner = Spinner(DOTS, "Packing things...")\n        spinner.start()\n        \n        time.sleep(2)\n        \n        spinner.stop()\n        # Get input without showing it being typed\n        if "friend" == prompt("Speak, [blue bold underline]friend[/blue bold underline], and enter", secure=True).lower():\n            \n            # Custom spinner animation\n            spinner_animation = [\'▉▉\', \'▌▐\', \'  \', \'▌▐\', \'▉▉\']\n            spinner = Spinner(spinner_animation, "Opening the Door of Durin...")\n            spinner.start()\n            \n            time.sleep(2)\n            \n            spinner.stop()\n        else:\n            spinner_animation = [\'🐙🌊    ⚔️ \', \'🐙 🌊   ⚔️ \', \'🐙  🌊  ⚔️ \', \'🐙   🌊 ⚔️ \', \'🐙    🌊⚔️ \']\n            spinner = Spinner(spinner_animation, "Getting attacked by an octopus...")\n            spinner.start()\n            \n            time.sleep(2)\n            \n            spinner.stop()\n\n        if \'The One Ring\' in items:\n            console.print("[green]You throw The One Ring to a lava from an eagle![/green]")\n        else:\n            console.print("[red]You forgot the right and brought Middle-Earth to its knees![/red]")\n        console.print(f"And you brought {potato_count} taters!")\n        \n```\n\nFor more information refer to [more_examples](https://petereon.github.io/beaupy/examples/) or definitive, but much less exciting [api documentation](https://petereon.github.io/beaupy/api/)\n\n## Roadmap\n\nThis repository has a [associated GitHub project](https://github.com/users/petereon/projects/3/views/1) where work that is currently done can be seen\n\n## Contributing\n\nIf you want to contribute, please feel free to suggest features or implement them yourself.\n\nAlso **please report any issues and bugs you might find!**\n\n### Development\n\nTo start development you can clone the repository:\n\n```sh\ngit clone https://github.com/petereon/beaupy.git\n```\n\nChange the directory to the project directory:\n\n```sh\ncd ./beaupy/\n```\n\nThis project uses [`poetry`](https://python-poetry.org/) as a dependency manager. You can install the dependencies using:\n\n```sh\npoetry install\n```\n\nFor testing, this project relies on [`ward`](https://github.com/darrenburns/ward). It is included as a development dependency, so\nafter installing the dependencies you can simply execute the following:\n\n```sh\npoetry run poe test\n```\n\nAfter you have made your changes, create a pull request towards a master branch of this repository\n\nLooking forward to your pull requests!\n\n## License\n\nThe project is licensed under the [MIT License](LICENSE).\n',
    'author': 'Peter Vyboch',
    'author_email': 'pvyboch1@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/petereon/beaupy',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7.8,<4.0.0',
}


setup(**setup_kwargs)
