# Fith Command Line Tools

Fith ships with 3 command line tools:

## fithc - The Fith Compiler

The fith compiler is called `fithc`. It translates fith code
into `5ir` code, which is then assembled into a `5vm` binary
with `5asm`. Alternatively, `fithc -s` assembles the code to
a binary in the same step.

```
usage: fithc [-h] [--include INCLUDE [INCLUDE ...]] [--output OUTPUT] [--no-include-baselib] [--assemble] [file]

Compile a fith program.

positional arguments:
  file                  Input file (default: stdin)

optional arguments:
  -h, --help            show this help message and exit
  --include INCLUDE [INCLUDE ...], -i INCLUDE [INCLUDE ...]
                        Include a fith file
  --output OUTPUT, -o OUTPUT
                        Output file (default: stdout)
  --no-include-baselib, --nostd
                        Do not include the fith baselib
  --assemble, -s        Assemble the code into a 5vm binary
```

## 5asm - The 5ir Assembler

The assembler for the `5ir` files generated by `fithc` is `5asm`.
It is used to translate `5ir` files to binaries for the `5vm`.

```
usage: 5asm [-h] [--output OUTPUT] [--stack-len STACK_LEN] [--fstack-len FSTACK_LEN] files [files ...]

Assemble 5ir files to a 5vm binary.

positional arguments:
  files                 Input file(s) (default: stdin)

optional arguments:
  -h, --help            show this help message and exit
  --output OUTPUT, -o OUTPUT
                        Output file (default: stdout)
  --stack-len STACK_LEN
                        Stack length (default: 100)
  --fstack-len FSTACK_LEN
                        Function stack length (default: 100)
```

## 5vm - The Fith Virtual Machine

The virtual machine in which fith code runs in is invoked with `5vm`.

```
usage: 5vm [-h] [--max-steps MAX_STEPS] [--verbose] [program]

Run a program on the 5vm.

positional arguments:
  program               Program file (default: stdin)

optional arguments:
  -h, --help            show this help message and exit
  --max-steps MAX_STEPS
                        Maximum run steps (default: 0 = no limit)
  --verbose, -v
```
