Additional documentation to develop the **Translator OpenPredict API**.

> Contributions, [feedbacks](https://github.com/MaastrichtU-IDS/translator-openpredict/issues) and pull requests are welcomed!

This repository uses [GitHub Actions](https://github.com/MaastrichtU-IDS/translator-openpredict/actions) to:

* Automatically run tests at each push to the `master` branch
* Publish the [OpenPredict package to PyPI](https://pypi.org/project/openpredict/) when a release is created (N.B.: the version of the package needs to be increased in [setup.py](https://github.com/MaastrichtU-IDS/translator-openpredict/blob/master/setup.py#L6) before).

**See [here](https://github.com/MaastrichtU-IDS/translator-openpredict/tree/master/docs/README-pydoc.md) to browse the Python code documentation** automatically generated by [pydoc-markdown](https://pydoc-markdown.readthedocs.io/en/latest/) 📖

# Example notebooks 📔

We provide [Jupyter Notebooks](https://jupyter.org/) with examples to use the OpenPredict API in this `docs` folder:

1. [Query the OpenPredict API](https://github.com/MaastrichtU-IDS/translator-openpredict/blob/master/docs/openpredict-examples.ipynb)
2. [Generate embeddings with pyRDF2Vec](https://github.com/MaastrichtU-IDS/translator-openpredict/blob/master/docs/openpredict-pyrdf2vec-embeddings.ipynb), and import them in the OpenPredict API

The notebook to generate embeddings requires to have Spark installed, you can use it with the `jupyter/all-spark-notebook` image easily with our `docker-compose.yml`:

```bash
cd docs
docker-compose up
```

> Default password is `password`

# Alternatives to install OpenPredict

### Instally locally with pip

Install `openpredict` from the source code with `pip`, the package will be automatically updated when the files changes locally :arrows_counterclockwise:

```bash
pip3 install -e .
```

#### Optional: isolate with a Virtual Environment

If you face conflicts with already installed packages, then you might want to use a [Virtual Environment](https://docs.python.org/3/tutorial/venv.html) to isolate the installation in the current folder before installing OpenPredict:

```bash
# Create the virtual environment folder in your workspace
python3 -m venv .venv
# Activate it using a script in the created folder
source .venv/bin/activate
```

> On Windows you might also need to install [Visual Studio C++ 14 Build Tools](https://visualstudio.microsoft.com/visual-cpp-build-tools/) (required for `numpy`)

Facing issue with `pytest` install even using virtual environments? Try this solution:

```bash
python3 -m pip install -e .
python3 -m pip install pytest
python3 -m pytest
```

### Install latest release from PyPI 🏷️

Install the latest release published on [PyPI](https://pypi.org/project/openpredict) (or see below to [run the API with Docker](#option-3-run-with-docker))

```bash
pip3 install openpredict
```

> It is currently recommended to install from the source code to get the latest version

# Alternatives to run OpenPredict

Requirements:

* [Docker](https://docs.docker.com/get-docker/) installed (and `docker-compose`)
* Python 3.6+

See the main README.md if you just want to OpenPredict locally, this documentation is for people who wants to use a specific triplestore, or try out new way to run OpenPredict

### Use Virtuoso as local triplestore 🗄️

1. Create the data folder:

   ```bash
   mkdir -p data
   ```

2. **Start the Virtuoso database** locally on http://localhost:8890 using Docker (login: `dba` / `dba`):

```bash
docker-compose -f docker-compose.dev.yml up -d --force-recreate
```

> Contributions are welcome! If you wish to help improve OpenPredict, see the [instructions to contribute :woman_technologist:](/CONTRIBUTING.md)

Once you finished you can stop the Virtuoso container, and restart it later. The data will be stored in `data/virtuoso`

```bash
docker-compose down
```

### Define environment variables locally 🏠

OpenPredict can be configured using environment variables in your local terminal:

* triplestore credentials
* path you want to be used as directory to store models and features files. By default it will do it in a `data` folder in the directory where you started the OpenPredict API.

```bash
export SPARQL_ENDPOINT_URL=https://graphdb.dumontierlab.com/repositories/translator-openpredict-dev
export SPARQL_ENDPOINT_UPDATE_URL=https://graphdb.dumontierlab.com/repositories/translator-openpredict-dev/statements
export SPARQL_USERNAME=import_user
export SPARQL_PASSWORD=password
export OPENPREDICT_APIKEY=myapikey
export OPENPREDICT_DATA_DIR=/data/openpredict
```

> You can add those exports to your `~/.bashrc` or `~/.zshrc` file to define it permanently.

The OpenPredict API can deployed in 3 different ways:

### Run with Docker 🐳

Running using Docker can be convenient if you just want to run the API without installing the package locally, or if it runs in production alongside other services.

Clone the [repository](https://github.com/MaastrichtU-IDS/translator-openpredict):

```bash
git clone https://github.com/MaastrichtU-IDS/translator-openpredict.git
cd translator-openpredict
```

1. For **development environments**: see above to use the default `docker-compose.yml` file to deploy the Virtuoso triplestore for development using Docker
2. For **production deployment** use the `docker-compose.prod.yml`

> The docker-compose is currently configured to deploy on [openpredict.semanticscience.org](https://openpredict.semanticscience.org/) using a [nginx-proxy for Docker](https://github.com/nginx-proxy)

Define the API key to authenticate when adding new embeddings in the `.env` file 🔑

```bash
echo "OPENPREDICT_APIKEY=yourapikey" > .env
```

Start the API in production using GraphDB as backend:

```bash
docker-compose up -d
```

> We use a [nginx-proxy for Docker](https://github.com/nginx-proxy/nginx-proxy) and [docker-letsencrypt-nginx-proxy-companion](https://github.com/nginx-proxy/docker-letsencrypt-nginx-proxy-companion) as reverse proxy for HTTP and HTTPS in production. You can change the proxy URL and port via environment variables `VIRTUAL_HOST`, `VIRTUAL_PORT` and `LETSENCRYPT_HOST` in the [docker-compose.yml](https://github.com/MaastrichtU-IDS/translator-openpredict/blob/master/docker-compose.yml) file.

Check the logs:

```bash
docker-compose logs
```

Stop the container:

```bash
docker-compose down
```

### Option 4: run on the DSRI

Running on https://api-openpredict.apps.dsri2.unimaas.nl

Go to the `openpredict` project:

```bash
oc project openpredict
```

Add the template to your project, if not already done (at the root of the repository)

```bash
oc apply -f openshift-template.yml
```

Start the application from the template:

```bash
oc new-app openpredict -p APPLICATION_NAME=api \
  -p STORAGE_SIZE=100Gi \
  -p APIKEY=mykey
```

Delete the application:

```bash
oc delete all,pvc,secret,configmaps,serviceaccount,rolebinding --selector app=api
```

## Generate Sphinx documentation 📖

> **❌ Currently not used** (done with pydoc which is much lighter, cf. `CONTRIBUTING.md`)

Documentation can be generated using [Sphinx doc](https://www.sphinx-doc.org/en/master/), see this article on [deploying Sphinx to GitHub Pages](https://circleci.com/blog/deploying-documentation-to-github-pages-with-continuous-integration/)

```bash
pip3 install sphinx
sphinx-quickstart sphinx-docs/ --project 'openpredict' --author 'Vincent Emonet'
cd sphinx-docs/
make html
```
