<!-- Please refer to our contributing documentation for any questions on submitting a pull request, or let us know here if you need any help: https://github.com/MaastrichtU-IDS/translator-openpredict/blob/master/CONTRIBUTING.md -->

## Pull request checklist

Please check if your PR fulfills the following requirements:
- [ ] The existing suite of tests passes (`pytest`)
- [ ] Docs have been reviewed and updated if needed (for bug fixes / features)
- [ ] Tests for the changes have been added (for bug fixes / features)


## Pull request type

<!-- Please do not submit updates to dependencies unless it fixes an issue. -->

<!-- Please try to limit your pull request to one type, submit multiple pull requests if needed. -->

Please check the type of change your PR introduces:
- [ ] Bugfix
- [ ] Feature
- [ ] Code style update (formatting, renaming)
- [ ] Refactoring (no functional changes, no api changes)
- [ ] Build related changes
- [ ] Documentation content changes
- [ ] Other (please describe):


## What is the current behavior?
<!-- Please describe the current behavior that you are modifying, or link to a relevant issue. -->

Issue Number: N/A


## What is the new behavior?
<!-- Please describe the behavior or changes that are being added by this PR. -->

## Does this introduce a breaking change?

- [ ] Yes
- [ ] No

<!-- If this introduces a breaking change, please describe the impact and migration path for existing applications below. -->


## Other information

<!-- Any other information that is important to this PR such as screenshots of how the component looks before and after the change. -->
