/*
 * Decompiled with CFR 0.152.
 */
package processing.serial;

import java.lang.reflect.Method;
import java.util.Map;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;
import processing.core.PApplet;

public class Serial
implements SerialPortEventListener {
    PApplet parent;
    public SerialPort port;
    Method serialAvailableMethod;
    Method serialEventMethod;
    byte[] buffer = new byte[32768];
    int inBuffer = 0;
    int readOffset = 0;
    int bufferUntilSize = 1;
    byte bufferUntilByte = 0;
    volatile boolean invokeSerialAvailable = false;

    public Serial(PApplet parent) {
        this(parent, "COM1", 9600, 'N', 8, 1.0f);
    }

    public Serial(PApplet parent, int baudRate) {
        this(parent, "COM1", baudRate, 'N', 8, 1.0f);
    }

    public Serial(PApplet parent, String portName) {
        this(parent, portName, 9600, 'N', 8, 1.0f);
    }

    public Serial(PApplet parent, String portName, int baudRate) {
        this(parent, portName, baudRate, 'N', 8, 1.0f);
    }

    public Serial(PApplet parent, String portName, int baudRate, char parity, int dataBits, float stopBits) {
        this.parent = parent;
        parent.registerMethod("dispose", (Object)this);
        parent.registerMethod("pre", (Object)this);
        parity = parity == 'O' ? (char)'\u0001' : (parity == 'E' ? (char)2 : (parity == 'M' ? (char)3 : (parity == 'S' ? (char)4 : (char)'\u0000')));
        int stopBitsIdx = 1;
        if (stopBits == 1.5f) {
            stopBitsIdx = 3;
        } else if (stopBits == 2.0f) {
            stopBitsIdx = 2;
        }
        this.port = new SerialPort(portName);
        try {
            this.port.openPort();
            this.port.setParams(baudRate, dataBits, stopBitsIdx, (int)parity);
            this.port.addEventListener((SerialPortEventListener)this, 1);
        }
        catch (SerialPortException e) {
            throw new RuntimeException("Error opening serial port " + e.getPortName() + ": " + e.getExceptionType());
        }
        this.serialEventMethod = this.findCallback("serialEvent");
        this.serialAvailableMethod = this.findCallback("serialAvailable");
    }

    private Method findCallback(String name) {
        try {
            return this.parent.getClass().getMethod(name, this.getClass());
        }
        catch (Exception exception) {
            try {
                return this.parent.getClass().getMethod(name, Object.class);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public void dispose() {
        this.stop();
    }

    public boolean active() {
        return this.port.isOpened();
    }

    public void pre() {
        if (this.serialAvailableMethod != null && this.invokeSerialAvailable) {
            this.invokeSerialAvailable = false;
            try {
                this.serialAvailableMethod.invoke((Object)this.parent, this);
            }
            catch (Exception e) {
                System.err.println("Error, disabling serialAvailable() for " + this.port.getPortName());
                System.err.println(e.getLocalizedMessage());
                this.serialAvailableMethod = null;
            }
        }
    }

    public int available() {
        return this.inBuffer - this.readOffset;
    }

    public void buffer(int size) {
        this.bufferUntilSize = size;
    }

    public void bufferUntil(int inByte) {
        this.bufferUntilSize = 0;
        this.bufferUntilByte = (byte)inByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            this.inBuffer = 0;
            this.readOffset = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean getCTS() {
        try {
            return this.port.isCTS();
        }
        catch (SerialPortException e) {
            throw new RuntimeException("Error reading the CTS line: " + e.getExceptionType());
        }
    }

    public boolean getDSR() {
        try {
            return this.port.isDSR();
        }
        catch (SerialPortException e) {
            throw new RuntimeException("Error reading the DSR line: " + e.getExceptionType());
        }
    }

    public static Map<String, String> getProperties(String portName) {
        return SerialPortList.getPortProperties((String)portName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int last() {
        if (this.inBuffer == this.readOffset) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int ret = this.buffer[this.inBuffer - 1] & 0xFF;
            this.inBuffer = 0;
            this.readOffset = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    public char lastChar() {
        return (char)this.last();
    }

    public static String[] list() {
        return SerialPortList.getPortNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        if (this.inBuffer == this.readOffset) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int ret = this.buffer[this.readOffset++] & 0xFF;
            if (this.inBuffer == this.readOffset) {
                this.inBuffer = 0;
                this.readOffset = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        if (this.inBuffer == this.readOffset) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            byte[] ret = new byte[this.inBuffer - this.readOffset];
            System.arraycopy(this.buffer, this.readOffset, ret, 0, ret.length);
            this.inBuffer = 0;
            this.readOffset = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int max) {
        if (this.inBuffer == this.readOffset) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int length = this.inBuffer - this.readOffset;
            if (length > max) {
                length = max;
            }
            byte[] ret = new byte[length];
            System.arraycopy(this.buffer, this.readOffset, ret, 0, length);
            this.readOffset += length;
            if (this.inBuffer == this.readOffset) {
                this.inBuffer = 0;
                this.readOffset = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] dest) {
        if (this.inBuffer == this.readOffset) {
            return 0;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int toCopy = this.inBuffer - this.readOffset;
            if (dest.length < toCopy) {
                toCopy = dest.length;
            }
            System.arraycopy(this.buffer, this.readOffset, dest, 0, toCopy);
            this.readOffset += toCopy;
            if (this.inBuffer == this.readOffset) {
                this.inBuffer = 0;
                this.readOffset = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return toCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int inByte) {
        if (this.inBuffer == this.readOffset) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int found;
            block8: {
                found = -1;
                int i = this.readOffset;
                while (i < this.inBuffer) {
                    if (this.buffer[i] == (byte)inByte) {
                        found = i;
                        break;
                    }
                    ++i;
                }
                if (found != -1) break block8;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            int toCopy = found - this.readOffset + 1;
            byte[] dest = new byte[toCopy];
            System.arraycopy(this.buffer, this.readOffset, dest, 0, toCopy);
            this.readOffset += toCopy;
            if (this.inBuffer == this.readOffset) {
                this.inBuffer = 0;
                this.readOffset = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return dest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int inByte, byte[] dest) {
        if (this.inBuffer == this.readOffset) {
            return 0;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int toCopy;
            block10: {
                int found;
                block9: {
                    found = -1;
                    int i = this.readOffset;
                    while (i < this.inBuffer) {
                        if (this.buffer[i] == (byte)inByte) {
                            found = i;
                            break;
                        }
                        ++i;
                    }
                    if (found != -1) break block9;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return 0;
                }
                toCopy = found - this.readOffset + 1;
                if (dest.length >= toCopy) break block10;
                System.err.println("The buffer passed to readBytesUntil() is to small to contain " + toCopy + " bytes up to and including " + "char " + (byte)inByte);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return -1;
            }
            System.arraycopy(this.buffer, this.readOffset, dest, 0, toCopy);
            this.readOffset += toCopy;
            if (this.inBuffer == this.readOffset) {
                this.inBuffer = 0;
                this.readOffset = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return toCopy;
        }
    }

    public char readChar() {
        return (char)this.read();
    }

    public String readString() {
        if (this.inBuffer == this.readOffset) {
            return null;
        }
        return new String(this.readBytes());
    }

    public String readStringUntil(int inByte) {
        byte[] temp = this.readBytesUntil(inByte);
        if (temp == null) {
            return null;
        }
        return new String(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void serialEvent(SerialPortEvent event) {
        if (event.getEventType() != 1) return;
        try {
            while (true) {
                int toRead;
                if ((toRead = this.port.getInputBufferBytesCount()) <= 0) {
                    return;
                }
                byte[] byArray = this.buffer;
                // MONITORENTER : this.buffer
                if (this.serialEventMethod != null) {
                    toRead = 1;
                }
                if (this.buffer.length < this.inBuffer + toRead) {
                    byte[] temp = new byte[this.buffer.length << 1];
                    System.arraycopy(this.buffer, 0, temp, 0, this.inBuffer);
                    this.buffer = temp;
                }
                byte[] read = this.port.readBytes(toRead);
                System.arraycopy(read, 0, this.buffer, this.inBuffer, read.length);
                this.inBuffer += read.length;
                // MONITOREXIT : byArray
                if (this.serialEventMethod != null && (this.bufferUntilSize > 0 && this.bufferUntilSize <= this.inBuffer - this.readOffset || this.bufferUntilSize == 0 && this.bufferUntilByte == this.buffer[this.inBuffer - 1])) {
                    try {
                        this.serialEventMethod.invoke((Object)this.parent, this);
                    }
                    catch (Exception e) {
                        System.err.println("Error, disabling serialEvent() for " + this.port.getPortName());
                        System.err.println(e.getLocalizedMessage());
                        this.serialEventMethod = null;
                    }
                }
                this.invokeSerialAvailable = true;
            }
        }
        catch (SerialPortException e) {
            throw new RuntimeException("Error reading from serial port " + e.getPortName() + ": " + e.getExceptionType());
        }
    }

    public void setDTR(boolean state) {
        try {
            this.port.setDTR(state);
        }
        catch (SerialPortException e) {
            throw new RuntimeException("Error setting the DTR line: " + e.getExceptionType());
        }
    }

    public void setRTS(boolean state) {
        try {
            this.port.setRTS(state);
        }
        catch (SerialPortException e) {
            throw new RuntimeException("Error setting the RTS line: " + e.getExceptionType());
        }
    }

    public void stop() {
        try {
            this.port.closePort();
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
        this.inBuffer = 0;
        this.readOffset = 0;
    }

    public void write(byte[] src) {
        try {
            this.port.writeBytes(src);
        }
        catch (SerialPortException e) {
            throw new RuntimeException("Error writing to serial port " + e.getPortName() + ": " + e.getExceptionType());
        }
    }

    public void write(int src) {
        try {
            this.port.writeInt(src);
        }
        catch (SerialPortException e) {
            throw new RuntimeException("Error writing to serial port " + e.getPortName() + ": " + e.getExceptionType());
        }
    }

    public void write(String src) {
        try {
            this.port.writeString(src);
        }
        catch (SerialPortException e) {
            throw new RuntimeException("Error writing to serial port " + e.getPortName() + ": " + e.getExceptionType());
        }
    }
}

