/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.python.core.BytecodeNotification;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyRunnable;
import org.python.core.imp;
import org.python.objectweb.asm.ClassReader;
import org.python.util.Generic;

public class BytecodeLoader {
    public static Class<?> makeClass(String name, byte[] data, Class<?> ... referents) {
        Loader loader2 = new Loader();
        for (Class<?> referent : referents) {
            try {
                ClassLoader cur = referent.getClassLoader();
                if (cur == null) continue;
                loader2.addParent(cur);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        Class<?> c = loader2.loadClassFromBytes(name, data);
        BytecodeNotification.notify(name, data, c);
        return c;
    }

    public static Class<?> makeClass(String name, List<Class<?>> referents, byte[] data) {
        if (referents != null) {
            return BytecodeLoader.makeClass(name, data, referents.toArray(new Class[referents.size()]));
        }
        return BytecodeLoader.makeClass(name, data, new Class[0]);
    }

    public static PyCode makeCode(String name, byte[] data, String filename) {
        try {
            Class<?> c = BytecodeLoader.makeClass(name, data, new Class[0]);
            Object o = c.getConstructor(String.class).newInstance(filename);
            return ((PyRunnable)o).getMain();
        }
        catch (Exception e) {
            throw Py.JavaError(e);
        }
    }

    public static class Loader
    extends URLClassLoader {
        private List<ClassLoader> parents = Generic.list();

        public Loader() {
            super(new URL[0]);
            this.parents.add(imp.getSyspathJavaLoader());
        }

        public void addParent(ClassLoader referent) {
            if (!this.parents.contains(referent)) {
                this.parents.add(0, referent);
            }
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            for (ClassLoader loader2 : this.parents) {
                try {
                    return loader2.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(name);
        }

        public Class<?> loadClassFromBytes(String name, byte[] data) {
            if (name.endsWith("$py")) {
                try {
                    ClassReader cr = new ClassReader(data);
                    name = cr.getClassName().replace('/', '.');
                }
                catch (RuntimeException cr) {
                    // empty catch block
                }
            }
            Class<?> c = this.defineClass(name, data, 0, data.length, this.getClass().getProtectionDomain());
            this.resolveClass(c);
            return c;
        }
    }
}

