/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.run;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.awt.Point;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import jycessing.mode.PyEditor;
import jycessing.mode.PythonMode;
import jycessing.mode.run.PdeSketch;
import jycessing.mode.run.SketchRunner;
import jycessing.mode.run.SketchService;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.SketchException;

public class SketchServiceProcess {
    private static final FilenameFilter JARS = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };
    private final PythonMode mode;
    private final PyEditor editor;
    private Process sketchServiceProcess;
    private SketchService sketchService;
    private volatile Runnable pendingSketchRequest = null;

    private static void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(SketchServiceProcess.class.getSimpleName()) + ": " + msg);
        }
    }

    public SketchServiceProcess(PythonMode mode, PyEditor editor) {
        this.mode = mode;
        this.editor = editor;
        this.start();
    }

    SketchServiceProcess(PythonMode mode, PyEditor editor, SketchService runningService) {
        this.mode = mode;
        this.editor = editor;
        this.sketchService = runningService;
    }

    public void start() {
        SketchServiceProcess.log("Starting sketch runner process.");
        ProcessBuilder pb = this.createServerCommand();
        pb.inheritIO();
        SketchServiceProcess.log("Running:\n" + pb.command());
        try {
            this.sketchServiceProcess = pb.start();
        }
        catch (IOException e) {
            Messages.showError((String)"PythonMode Error", (String)"Cannot start python sketch runner.", (Throwable)e);
        }
    }

    private void handleRemoteException(RemoteException e) throws SketchException {
        Throwable cause = e.getCause();
        if (!(cause instanceof SocketTimeoutException) && !(cause instanceof ConnectException)) {
            throw new SketchException(e.getMessage());
        }
        SketchServiceProcess.log("SketchRunner either hung or not there. Restarting it.");
        this.restartServerProcess();
    }

    public void handleReady(SketchService service) {
        SketchServiceProcess.log("handleReady()");
        this.sketchService = service;
        SketchServiceProcess.log("Successfully bound SketchRunner stub.");
        Runnable req = this.pendingSketchRequest;
        this.pendingSketchRequest = null;
        if (req != null) {
            req.run();
        }
    }

    public void handleSketchStopped() {
        SketchServiceProcess.log("Sketch stopped.");
        this.editor.deactivateRun();
    }

    private ProcessBuilder createServerCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(Platform.getJavaPath());
        if (Preferences.getBoolean((String)"run.options.memory")) {
            command.add("-Xms" + Preferences.get((String)"run.options.memory.initial") + "m");
            command.add("-Xmx" + Preferences.get((String)"run.options.memory.maximum") + "m");
        }
        if (Platform.isMacOS()) {
            command.add("-Dapple.awt.UIElement=true");
            command.add("-Xdock:name=Processing");
        }
        if (Platform.isWindows()) {
            command.add("-Dpython.console.encoding=UTF-8");
        }
        if (PythonMode.VERBOSE) {
            command.add("-Dverbose=true");
        }
        command.add("-Djava.library.path=" + System.getProperty("java.library.path"));
        ArrayList<CharSequence> cp = new ArrayList<CharSequence>();
        cp.addAll(Collections2.filter(Arrays.asList(System.getProperty("java.class.path").split(Pattern.quote(File.pathSeparator))), Predicates.not(Predicates.or(Predicates.containsPattern("(ant|ant-launcher|antlr|netbeans.*|osgi.*|jdi.*|ibm\\.icu.*|jna)\\.jar$"), Predicates.containsPattern("/processing/app/(test|lib)/")))));
        File[] fileArray = new File(Platform.getContentFile((String)"core"), "library").listFiles(JARS);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File jar = fileArray[n2];
            cp.add(jar.getAbsolutePath());
            ++n2;
        }
        File[] libJars = this.mode.getContentFile("mode").getAbsoluteFile().listFiles(JARS);
        if (libJars != null) {
            File[] fileArray2 = libJars;
            int n3 = libJars.length;
            n = 0;
            while (n < n3) {
                File jar = fileArray2[n];
                cp.add(jar.getAbsolutePath());
                ++n;
            }
        } else {
            SketchServiceProcess.log("No library jars found; I assume we're running in Eclipse.");
        }
        command.add("-cp");
        command.add(Joiner.on(File.pathSeparator).join(cp));
        command.add("-ea");
        command.add(SketchRunner.class.getName());
        command.add(this.editor.getId());
        return new ProcessBuilder(command);
    }

    private void restartServerProcess() {
        this.shutdown();
        this.start();
    }

    public void runSketch(final PdeSketch sketch) throws SketchException {
        this.pendingSketchRequest = new Runnable(){

            @Override
            public void run() {
                try {
                    SketchServiceProcess.this.runSketch(sketch);
                }
                catch (SketchException e) {
                    SketchServiceProcess.this.editor.statusError((Exception)((Object)e));
                }
            }
        };
        if (this.sketchService == null) {
            SketchServiceProcess.log("Sketch service not running. Leaving pending request to run sketch.");
            this.restartServerProcess();
            return;
        }
        try {
            this.sketchService.startSketch(sketch);
            this.pendingSketchRequest = null;
            return;
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
            SketchServiceProcess.log("Leaving pending request to run sketch.");
            return;
        }
    }

    public void stopSketch() throws SketchException {
        if (this.sketchService == null) {
            SketchServiceProcess.log("Sketch runner apparently not running; can't stop sketch.");
            this.handleSketchStopped();
            this.restartServerProcess();
            return;
        }
        try {
            this.sketchService.stopSketch();
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public void shutdown() {
        if (this.sketchService != null) {
            SketchServiceProcess.log("Telling sketch runner to shutdown.");
            try {
                this.sketchService.shutdown();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.sketchServiceProcess != null) {
            SketchServiceProcess.log("Killing sketch runner process.");
            this.sketchServiceProcess.destroy();
            SketchServiceProcess.log("Waiting for sketch runner process to exit.");
            try {
                this.sketchServiceProcess.waitFor();
                SketchServiceProcess.log("Sketcher runner process exited normally.");
            }
            catch (InterruptedException e) {
                SketchServiceProcess.log("Interrupted while waiting for sketch runner to exit.");
            }
            this.sketchServiceProcess = null;
        }
    }

    public void printStdOut(String s) {
        this.editor.printOut(s);
    }

    public void printStdErr(String s) {
        this.editor.printErr(s);
    }

    public void handleSketchException(Exception e) {
        this.editor.statusError(e);
    }

    public void handleSketchMoved(Point leftTop) {
        this.editor.setSketchLocation(leftTop);
    }
}

