/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.run;

import java.awt.Point;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jycessing.mode.PyEditor;
import jycessing.mode.PythonMode;
import jycessing.mode.run.ModeService;
import jycessing.mode.run.ModeWaiter;
import jycessing.mode.run.RMIUtils;
import jycessing.mode.run.SketchService;
import jycessing.mode.run.SketchServiceProcess;
import processing.app.Messages;

public class SketchServiceManager
implements ModeService {
    private static final String DEBUG_SKETCH_RUNNER_KEY = "$SKETCHRUNNER$";
    private final PythonMode mode;
    private final Map<String, SketchServiceProcess> sketchServices = new HashMap<String, SketchServiceProcess>();
    private final Set<String> killedSketchServices = new HashSet<String>();
    private volatile boolean isStarted = false;
    private SketchService debugSketchRunner;

    private static void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(SketchServiceManager.class.getSimpleName()) + ": " + msg);
        }
    }

    public SketchServiceManager(PythonMode mode) {
        this.mode = mode;
    }

    public SketchServiceProcess createSketchService(PyEditor editor) {
        SketchServiceProcess p;
        if (PythonMode.SKETCH_RUNNER_FIRST) {
            p = new SketchServiceProcess(this.mode, editor, this.debugSketchRunner);
            this.sketchServices.put(DEBUG_SKETCH_RUNNER_KEY, p);
        } else {
            p = new SketchServiceProcess(this.mode, editor);
            this.sketchServices.put(editor.getId(), p);
        }
        return p;
    }

    public void destroySketchService(PyEditor editor) {
        SketchServiceProcess process = this.sketchServices.remove(editor.getId());
        this.killedSketchServices.add(editor.getId());
        if (process != null) {
            process.shutdown();
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void start() {
        this.isStarted = true;
        try {
            if (PythonMode.SKETCH_RUNNER_FIRST) {
                ModeService stub = (ModeService)RMIUtils.export(this);
                ModeWaiter modeWaiter = RMIUtils.lookup(ModeWaiter.class);
                modeWaiter.modeReady(stub);
            } else {
                RMIUtils.bind(this, ModeService.class);
            }
        }
        catch (Exception e) {
            Messages.showError((String)"PythonMode Error", (String)"Cannot start python sketch service.", (Throwable)e);
            return;
        }
    }

    private SketchServiceProcess processFor(String editorId) {
        if (PythonMode.SKETCH_RUNNER_FIRST) {
            return this.sketchServices.get(DEBUG_SKETCH_RUNNER_KEY);
        }
        SketchServiceProcess p = this.sketchServices.get(editorId);
        if (p == null) {
            throw new RuntimeException("I somehow got a message from the sketch runner for " + editorId + " but don't have an active service process for it!");
        }
        return p;
    }

    @Override
    public void handleReady(String editorId, SketchService service) {
        if (PythonMode.SKETCH_RUNNER_FIRST) {
            SketchServiceManager.log("Debug sketch runner is ready.");
            this.debugSketchRunner = service;
            return;
        }
        this.processFor(editorId).handleReady(service);
    }

    @Override
    public void handleSketchException(String editorId, Exception e) {
        this.processFor(editorId).handleSketchException(e);
    }

    @Override
    public void handleSketchStopped(String editorId) {
        if (this.killedSketchServices.remove(editorId)) {
            return;
        }
        this.processFor(editorId).handleSketchStopped();
    }

    @Override
    public void handleSketchMoved(String editorId, Point leftTop) {
        this.processFor(editorId).handleSketchMoved(leftTop);
    }

    @Override
    public void printStdErr(String editorId, String s) {
        this.processFor(editorId).printStdErr(s);
    }

    @Override
    public void printStdOut(String editorId, String s) {
        this.processFor(editorId).printStdOut(s);
    }
}

