/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.run;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import jycessing.mode.PythonMode;

public class RMIUtils {
    private static final boolean EXTREMELY_VERBOSE = false;
    static final int RMI_PORT = 8220;

    static {
        System.setProperty("sun.rmi.transport.tcp.localHostNameTimeOut", "1000");
        System.setProperty("java.rmi.server.hostname", "127.0.0.1");
        System.setProperty("sun.rmi.transport.tcp.responseTimeout", "1500");
    }

    private static void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(RMIUtils.class.getSimpleName()) + ": " + msg);
        }
    }

    private RMIUtils() {
    }

    public static Registry registry() throws RemoteException {
        try {
            return LocateRegistry.createRegistry(8220);
        }
        catch (RemoteException remoteException) {
            return LocateRegistry.getRegistry(8220);
        }
    }

    public static void bind(Remote remote, Class<? extends Remote> remoteInterface) throws RMIProblem {
        final String registryKey = remoteInterface.getSimpleName();
        try {
            Remote stub = RMIUtils.export(remote);
            RMIUtils.log("Attempting to bind instance of " + remote.getClass().getName() + " to registry as " + registryKey);
            RMIUtils.registry().bind(registryKey, stub);
            RMIUtils.log("Bound.");
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        RMIUtils.log("Unbinding " + registryKey + " from registry.");
                        RMIUtils.registry().unbind(registryKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }));
        }
        catch (Exception e) {
            throw new RMIProblem(e);
        }
    }

    public static Remote export(Remote remote) throws RMIProblem {
        try {
            return UnicastRemoteObject.exportObject(remote, 0);
        }
        catch (RemoteException e) {
            throw new RMIProblem(e);
        }
    }

    public static <T extends Remote> T lookup(Class<T> klass) throws RMIProblem {
        try {
            RMIUtils.log("Looking up ModeService in registry.");
            return (T)RMIUtils.registry().lookup(klass.getSimpleName());
        }
        catch (Exception e) {
            throw new RMIProblem(e);
        }
    }

    public static class RMIProblem
    extends Exception {
        RMIProblem(Exception e) {
            super(e);
        }
    }
}

