/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.export;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jycessing.mode.PyEditor;
import jycessing.mode.PythonMode;
import jycessing.mode.export.Arch;
import jycessing.mode.export.Exporter;
import jycessing.mode.export.PlatformExport;
import processing.app.Library;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.Util;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.data.XML;

public class WindowsExport
extends PlatformExport {
    @Override
    protected void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(WindowsExport.class.getSimpleName()) + ": " + msg);
        }
    }

    public WindowsExport(Arch arch, Sketch sketch, PyEditor editor, Set<Library> libraries) {
        this.id = 1;
        this.arch = arch;
        this.name = String.valueOf(PConstants.platformNames[this.id]) + arch.bits;
        this.sketch = sketch;
        this.editor = editor;
        this.libraries = libraries;
    }

    @Override
    public void export() throws IOException {
        boolean embedJava = this.id == PApplet.platform && Preferences.getBoolean((String)"export.application.embed_java") && this.arch == Exporter.processingArch;
        File destFolder = new File(this.sketch.getFolder(), "application." + this.name);
        File javaFolder = new File(destFolder, "java");
        this.copyBasicStructure(destFolder);
        if (embedJava) {
            this.log("Embedding java in export.");
            javaFolder.mkdirs();
            Util.copyDir((File)Platform.getJavaHome(), (File)javaFolder);
        }
        XML l4jConfig = this.buildLaunch4jConfig(destFolder, embedJava);
        File configFile = Files.createTempFile("config", ".xml", new FileAttribute[0]).toFile();
        l4jConfig.save(configFile);
        this.runLaunch4j(configFile);
        configFile.delete();
        this.log("Done.");
    }

    private XML buildLaunch4jConfig(File destFolder, boolean embedJava) {
        this.log("Building launch4j configuration.");
        String sketchName = this.sketch.getName();
        boolean setMemory = Preferences.getBoolean((String)"run.options.memory");
        boolean presentMode = Preferences.getBoolean((String)"export.application.fullscreen");
        boolean stopButton = Preferences.getBoolean((String)"export.application.stop") && presentMode;
        File iconFile = this.editor.getModeContentFile("application/windows/sketch.ico");
        File jycessingFolder = new File(destFolder, "lib/jycessing");
        XML config2 = new XML("launch4jConfig");
        config2.addChild("headerType").setContent("gui");
        config2.addChild("outfile").setContent(new File(destFolder, String.valueOf(sketchName) + ".exe").getAbsolutePath());
        config2.addChild("dontWrapJar").setContent("true");
        config2.addChild("errTitle").setContent("Sketchy Behavior");
        config2.addChild("icon").setContent(iconFile.getAbsolutePath());
        config2.addChild("chdir").setContent(".");
        config2.addChild(this.buildJREOptions(embedJava, setMemory, this.arch));
        config2.addChild(this.buildRunnerOptions(presentMode, stopButton));
        config2.addChild(this.buildClassPathOptions(jycessingFolder));
        this.log("Configuration done: " + config2.format(0));
        return config2;
    }

    private void runLaunch4j(File configFile) throws IOException {
        this.log("Running launch4j.");
        File javaHome = new File(System.getProperty("java.home"));
        File javaExecutable = PApplet.platform == 1 ? new File(javaHome, "bin/java.exe") : new File(javaHome, "bin/java");
        if (!javaExecutable.exists()) {
            throw new IOException("Can't find java executable. Huh?");
        }
        File launch4jFolder = Platform.getContentFile((String)"modes/java/application/launch4j");
        if (!launch4jFolder.exists()) {
            throw new IOException("Can't find launch4j to wrap application with.");
        }
        File launch4jJar = new File(launch4jFolder, "launch4j.jar");
        File xstreamJar = new File(launch4jFolder, "lib/xstream.jar");
        ProcessBuilder pb = new ProcessBuilder(javaExecutable.getAbsolutePath(), "-cp", String.valueOf(launch4jJar.getAbsolutePath()) + System.getProperty("path.separator") + xstreamJar.getAbsolutePath(), "net.sf.launch4j.Main", configFile.getAbsolutePath());
        if (PythonMode.VERBOSE) {
            this.log("Launch4j command:");
            List<String> command = pb.command();
            for (String s : command) {
                this.log("    " + s);
            }
        }
        final Process launch4jProcess = pb.start();
        if (PythonMode.VERBOSE) {
            Thread captureOutput = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedReader stderr = new BufferedReader(new InputStreamReader(launch4jProcess.getInputStream()));
                    try {
                        String line;
                        while ((line = stderr.readLine()) != null) {
                            WindowsExport.this.log(line);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            captureOutput.start();
        }
        try {
            int result2 = launch4jProcess.waitFor();
            if (result2 != 0) {
                throw new IOException("Launch4j seems to have failed.");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Launch4j seems to have been interrupted.");
        }
    }

    private XML buildJREOptions(boolean embedJava, boolean setMemory, Arch arch) {
        this.log("Building JRE options.");
        XML jre = new XML("jre");
        if (embedJava) {
            jre.addChild("path").setContent("\"%EXEDIR%\\java\"");
        }
        jre.addChild("minVersion").setContent("1.7.0_40");
        switch (arch) {
            case AMD64: {
                jre.addChild("runtimeBits").setContent("64");
                break;
            }
            case X86: {
                jre.addChild("runtimeBits").setContent("32");
            }
        }
        if (setMemory) {
            jre.addChild("initialHeapSize").setContent(Preferences.get((String)"run.options.memory.initial"));
            jre.addChild("maxHeapSize").setContent(Preferences.get((String)"run.options.memory.maximum"));
        }
        jre.addChild("opt").setContent("-Djna.nosys=true");
        jre.addChild("opt").setContent("-Djava.library.path=\".\\lib\"");
        jre.addChild("opt").setContent("-ea");
        jre.addChild("opt").setContent("-splash:\"./lib/jycessing/splash.png\"");
        if (PythonMode.VERBOSE) {
            jre.addChild("opt").setContent("-Dverbose=true");
        }
        return jre;
    }

    private XML buildRunnerOptions(boolean presentMode, boolean stopButton) {
        this.log("Building Runner options.");
        ArrayList<String> runnerOptions = new ArrayList<String>();
        if (presentMode) {
            runnerOptions.add("fullScreen");
            runnerOptions.add("BGCOLOR=" + Preferences.get((String)"run.present.bgcolor"));
        }
        if (stopButton) {
            runnerOptions.add("--stop-color=" + Preferences.get((String)"run.present.stop.color"));
        } else {
            runnerOptions.add("--hide-stop");
        }
        runnerOptions.add("--noredirect");
        runnerOptions.add("--exported");
        runnerOptions.add("\"source\\" + this.sketch.getCode(0).getFileName() + "\"");
        StringBuilder runnerOptionsOutput = new StringBuilder();
        for (String o : runnerOptions) {
            runnerOptionsOutput.append(" " + o);
        }
        XML result2 = new XML("cmdLine");
        result2.setContent(runnerOptionsOutput.toString());
        return result2;
    }

    private XML buildClassPathOptions(File jycessingFolder) {
        this.log("Building classpath options.");
        XML classPathOptions = new XML("classPath");
        classPathOptions.addChild("mainClass").setContent("jycessing.Runner");
        File[] fileArray = jycessingFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().toLowerCase().endsWith(".jar") || f.getName().toLowerCase().endsWith(".zip")) {
                classPathOptions.addChild("cp").setContent("./lib/jycessing/" + f.getName());
            }
            ++n2;
        }
        return classPathOptions;
    }
}

