/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.export;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import jycessing.mode.PyEditor;
import jycessing.mode.export.Arch;
import processing.app.Library;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Util;

public abstract class PlatformExport {
    protected int id;
    protected String name;
    protected PyEditor editor;
    protected Sketch sketch;
    protected Set<Library> libraries;
    protected Arch arch;

    protected abstract void log(String var1);

    public abstract void export() throws IOException;

    public void copyBasicStructure(File destFolder) throws IOException {
        boolean hasData = this.sketch.hasDataFolder();
        boolean hasCode = this.sketch.hasCodeFolder();
        boolean deletePrevious = Preferences.getBoolean((String)"export.delete_target_folder");
        File libFolder = new File(destFolder, "lib");
        File codeFolder = new File(destFolder, "code");
        File sourceFolder = new File(destFolder, "source");
        File dataFolder = new File(destFolder, "data");
        File jycessingFolder = new File(libFolder, "jycessing");
        if (deletePrevious) {
            this.log("Removing old export folder.");
            Util.removeDir((File)destFolder);
        }
        destFolder.mkdirs();
        if (hasData) {
            this.log("Copying data folder to export.");
            dataFolder.mkdirs();
            Util.copyDir((File)this.sketch.getDataFolder(), (File)dataFolder);
        }
        if (hasCode) {
            this.log("Copying code folder to export.");
            codeFolder.mkdirs();
            Util.copyDir((File)this.sketch.getCodeFolder(), (File)codeFolder);
        }
        this.log("Copying source to export.");
        sourceFolder.mkdirs();
        Object[] objectArray = this.sketch.getCode();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode code2 = objectArray[n2];
            code2.copyTo(new File(sourceFolder, code2.getFileName()));
            ++n2;
        }
        this.log("Copying libraries to export.");
        libFolder.mkdirs();
        for (Library library : this.libraries) {
            File libraryExportFolder = new File(libFolder, String.valueOf(library.getFolder().getName()) + "/library/");
            libraryExportFolder.mkdirs();
            File[] fileArray = library.getApplicationExports(this.id, Integer.toString(this.arch.bits));
            int n3 = fileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                File exportFile = fileArray[n4];
                this.log("Exporting: " + exportFile);
                String exportName = exportFile.getName();
                if (!exportFile.exists()) {
                    System.err.println("The file " + exportName + " is mentioned in the export.txt from " + library + " but does not actually exist. Moving on.");
                } else if (exportFile.isDirectory()) {
                    Util.copyDir((File)exportFile, (File)new File(libraryExportFolder, exportName));
                } else {
                    Util.copyFile((File)exportFile, (File)new File(libraryExportFolder, exportName));
                }
                ++n4;
            }
        }
        jycessingFolder.mkdirs();
        this.log("Copying core processing stuff to export");
        objectArray = new Library(Platform.getContentFile((String)"core")).getApplicationExports(this.id, Integer.toString(this.arch.bits));
        n = objectArray.length;
        int n5 = 0;
        while (n5 < n) {
            SketchCode exportFile = objectArray[n5];
            if (exportFile.isDirectory()) {
                Util.copyDir((File)exportFile, (File)new File(jycessingFolder, exportFile.getName()));
            } else {
                Util.copyFile((File)exportFile, (File)new File(jycessingFolder, exportFile.getName()));
            }
            ++n5;
        }
        this.log("Copying core processing.py .jars to export");
        Util.copyDir((File)this.editor.getModeContentFile("mode"), (File)jycessingFolder);
        this.log("Copying splash screen to export");
        Util.copyFile((File)this.editor.getSplashFile(), (File)new File(jycessingFolder, "splash.png"));
    }
}

