/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.export;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jycessing.mode.PyEditor;
import jycessing.mode.PythonMode;
import jycessing.mode.export.Arch;
import jycessing.mode.export.PlatformExport;
import processing.app.Library;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.Util;
import processing.core.PApplet;
import processing.core.PConstants;

public class MacExport
extends PlatformExport {
    private static final Pattern sketchPattern = Pattern.compile("@@sketch@@");

    @Override
    protected void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(MacExport.class.getSimpleName()) + ": " + msg);
        }
    }

    public MacExport(Sketch sketch, PyEditor editor, Set<Library> libraries) {
        this.id = 2;
        this.name = PConstants.platformNames[this.id];
        this.sketch = sketch;
        this.editor = editor;
        this.libraries = libraries;
        this.arch = Arch.AMD64;
    }

    @Override
    public void export() throws IOException {
        boolean embedJava = this.id == PApplet.platform && Preferences.getBoolean((String)"export.application.embed_java");
        File destFolder = new File(this.sketch.getFolder(), "application." + this.name);
        File appRootFolder = new File(destFolder, String.valueOf(this.sketch.getName()) + ".app");
        File contentsFolder = new File(appRootFolder, "Contents");
        File binFolder = new File(contentsFolder, "MacOS");
        File resourcesFolder = new File(contentsFolder, "Resources");
        File processingFolder = new File(contentsFolder, "Processing");
        this.copyBasicStructure(processingFolder);
        this.copyStaticResources(resourcesFolder);
        if (embedJava) {
            this.copyJDKPlugin(new File(contentsFolder, "PlugIns"));
        }
        this.setUpInfoPlist(new File(contentsFolder, "Info.plist"), this.sketch.getName());
        this.setUpExecutable(binFolder, processingFolder, this.sketch.getName(), embedJava);
        this.log("Done.");
    }

    private void copyJDKPlugin(File targetPluginsFolder) throws IOException {
        File sourceJDKFolder = Platform.getContentFile((String)"../PlugIns").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jdk") && !name.startsWith(".");
            }
        })[0].getAbsoluteFile();
        this.log("Copying JDK from " + sourceJDKFolder);
        targetPluginsFolder.mkdirs();
        File targetJDKFolder = new File(targetPluginsFolder, sourceJDKFolder.getName());
        Util.copyDirNative((File)sourceJDKFolder, (File)targetJDKFolder);
    }

    private void setUpInfoPlist(File targetInfoPlist, String sketchName) throws IOException {
        this.log("Setting up Info.plist.");
        targetInfoPlist.getAbsoluteFile().getParentFile().mkdirs();
        Path infoPlistTemplate = this.editor.getModeContentFile("application/macosx/Info.plist.tmpl").toPath();
        String infoPlistTemplateText = new String(Files.readAllBytes(infoPlistTemplate), "UTF-8");
        Matcher sketchNameMatcher = sketchPattern.matcher(infoPlistTemplateText);
        Files.write(targetInfoPlist.toPath(), sketchNameMatcher.replaceAll(sketchName).getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    }

    private void copyStaticResources(File resourcesFolder) throws IOException {
        this.log("Moving static macosx resources.");
        File osxFolder = this.editor.getModeContentFile("application/macosx");
        resourcesFolder.mkdirs();
        Util.copyFile((File)new File(osxFolder, "sketch.icns"), (File)new File(resourcesFolder, "sketch.icns"));
        Util.copyFile((File)new File(osxFolder, "dialogs.applescript"), (File)new File(resourcesFolder, "dialogs.applescript"));
    }

    private void setUpExecutable(File binFolder, File processingFolder, String sketchName, boolean embedJava) throws IOException {
        this.log("Creating shell script.");
        boolean setMemory = Preferences.getBoolean((String)"run.options.memory");
        boolean presentMode = Preferences.getBoolean((String)"export.application.fullscreen");
        boolean stopButton = Preferences.getBoolean((String)"export.application.stop") && presentMode;
        binFolder.mkdirs();
        File scriptFile = new File(binFolder, this.sketch.getName());
        PrintWriter script = new PrintWriter(scriptFile);
        script.print("#!/bin/bash\n");
        script.print("CONTENTS=\"$( cd \"$( dirname \"$0\" )/..\" && pwd )\"\n");
        if (!embedJava) {
            this.log("Adding java-locating prelude to script.");
            Path findJavaScript = this.editor.getModeContentFile("application/macosx/findjava").toPath();
            String findJava = new String(Files.readAllBytes(findJavaScript), "UTF-8").replaceAll("\\r\\n?", "\n");
            script.print(String.valueOf(findJava) + "\n");
        } else {
            script.print("JAVA=\"$(find $CONTENTS/PlugIns -maxdepth 1 -type d -name '*jdk')/Contents/Home/jre/bin/java\"\n");
        }
        script.print("APPDIR=\"$CONTENTS/Processing\"\n");
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Djna.nosys=true");
        options.add("-Djava.library.path=\"$APPDIR:$APPDIR/lib:$APPDIR/lib/jycessing\"");
        options.add("-ea");
        if (setMemory) {
            options.add("-Xms" + Preferences.get((String)"run.options.memory.initial") + "m");
            options.add("-Xmx" + Preferences.get((String)"run.options.memory.maximum") + "m");
        }
        StringWriter classpath = new StringWriter();
        File[] fileArray = new File(processingFolder, "lib/jycessing").listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().toLowerCase().endsWith(".jar") || f.getName().toLowerCase().endsWith(".zip")) {
                classpath.append("$APPDIR/lib/jycessing/" + f.getName() + ":");
            }
            ++n2;
        }
        options.add("-cp");
        options.add("\"" + classpath.toString().substring(0, classpath.toString().length() - 1) + "\"");
        if (!presentMode) {
            options.add("-splash:\"$APPDIR/lib/jycessing/splash.png\"");
        }
        options.add("-Xdock:icon=\"$CONTENTS/Resources/sketch.icns\"");
        options.add("-Xdock:name=\"" + sketchName + "\"");
        if (PythonMode.VERBOSE) {
            options.add("-Dverbose=true");
        }
        options.add("jycessing.Runner");
        options.add("--noredirect");
        options.add("--exported");
        if (presentMode) {
            options.add("fullScreen");
            options.add("BGCOLOR=" + Preferences.get((String)"run.present.bgcolor"));
        }
        if (stopButton) {
            options.add("--stop-color=" + Preferences.get((String)"run.present.stop.color"));
        } else {
            options.add("--hide-stop");
        }
        options.add("\"$APPDIR/source/" + this.sketch.getCode(0).getFileName() + "\"");
        script.print("$JAVA");
        for (String o : options) {
            script.print(" " + o);
        }
        script.print("\n");
        script.close();
        this.log("Setting script executable.");
        try {
            Files.setPosixFilePermissions(scriptFile.toPath(), PosixFilePermissions.fromString("rwxrwxrwx"));
        }
        catch (UnsupportedOperationException e) {
            this.log("Couldn't set script executable... .app should work anyway, though");
        }
    }
}

