/*
 * Decompiled with CFR 0.152.
 */
package jycessing.mode.export;

import java.io.File;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import jycessing.mode.PythonMode;
import org.python.antlr.Visitor;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.Str;
import org.python.antlr.base.mod;
import org.python.core.CompilerFlags;
import org.python.core.ParserFacade;
import processing.app.Base;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Sketch;
import processing.app.SketchCode;

public class ImportExtractor {
    private static final File[] libLocations = new File[]{Platform.getContentFile((String)"modes/java/libraries"), Base.getSketchbookLibrariesFolder()};
    private final Sketch sketch;
    private final Set<Library> libraries;

    private static void log(String msg) {
        if (PythonMode.VERBOSE) {
            System.err.println(String.valueOf(ImportExtractor.class.getSimpleName()) + ": " + msg);
        }
    }

    public ImportExtractor(Sketch sketch) {
        this.sketch = sketch;
        this.libraries = new HashSet<Library>();
        this.extract();
    }

    public Set<Library> getLibraries() {
        return this.libraries;
    }

    private void extract() {
        ImportVisitor visitor2 = new ImportVisitor();
        SketchCode[] sketchCodeArray = this.sketch.getCode();
        int n = sketchCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                mod ast2;
                SketchCode code2 = sketchCodeArray[n2];
                ImportExtractor.log("Examining " + code2.getFileName());
                try {
                    ast2 = ParserFacade.parseExpressionOrModule(new StringReader(code2.getProgram()), code2.getFileName(), new CompilerFlags());
                }
                catch (Exception e) {
                    System.err.println("Couldn't parse " + code2.getFileName());
                    visitor2.failure = true;
                    break block11;
                }
                try {
                    visitor2.visit(ast2);
                }
                catch (Exception e) {
                    System.err.println("Couldn't visit " + code2.getFileName());
                    visitor2.failure = true;
                }
            }
            ++n2;
        }
        if (visitor2.failure) {
            Messages.showWarning((String)"Library Problems", (String)"I can't figure out all of the java libraries you're using. Your exported sketch might not work.");
        }
        for (String libName : visitor2.importNames) {
            boolean found = false;
            File[] fileArray = libLocations;
            int n3 = libLocations.length;
            int n4 = 0;
            while (n4 < n3) {
                File parent = fileArray[n4];
                File libDir = new File(parent, libName);
                if (libDir.exists()) {
                    if (found) {
                        System.err.println("Found multiple versions of library " + libName);
                        System.err.println("Choosing one arbitrarily.");
                    } else {
                        found = true;
                        this.libraries.add(new Library(libDir));
                    }
                }
                ++n4;
            }
            if (found) continue;
            System.err.println("Couldn't find library " + libName);
        }
    }

    private static class ImportVisitor
    extends Visitor {
        public final Set<String> importNames = new HashSet<String>();
        public boolean failure = false;

        @Override
        public Object visitCall(Call funcall) throws Exception {
            if (funcall.getInternalFunc().getToken().getText().equals("add_library")) {
                if (funcall.getInternalArgs().get(0) instanceof Str) {
                    String text2 = funcall.getInternalArgs().get(0).getToken().getText();
                    String lib = text2.substring(1, text2.length() - 1);
                    this.importNames.add(lib);
                    ImportExtractor.log("Found library: " + lib);
                } else {
                    System.err.println("I can't figure out what libraries you're using if you don't pass a string to add_library.\nPlease replace " + funcall.getInternalArgs().get(0).getToken().getText() + " with the name of the library you're importing.");
                    this.failure = true;
                }
            }
            return super.visitCall(funcall);
        }
    }
}

